/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.models.NeonDatabaseInner;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.NeonDatabase;
import com.azure.resourcemanager.neonpostgres.models.NeonDatabaseProperties;

public final class NeonDatabaseImpl
implements NeonDatabase,
NeonDatabase.Definition,
NeonDatabase.Update {
    private NeonDatabaseInner innerObject;
    private final NeonPostgresManager serviceManager;
    private String resourceGroupName;
    private String organizationName;
    private String projectName;
    private String branchName;
    private String neonDatabaseName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public NeonDatabaseProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public NeonDatabaseInner innerModel() {
        return this.innerObject;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public NeonDatabaseImpl withExistingBranche(String resourceGroupName, String organizationName, String projectName, String branchName) {
        this.resourceGroupName = resourceGroupName;
        this.organizationName = organizationName;
        this.projectName = projectName;
        this.branchName = branchName;
        return this;
    }

    @Override
    public NeonDatabase create() {
        this.innerObject = this.serviceManager.serviceClient().getNeonDatabases().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonDatabaseName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NeonDatabase create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNeonDatabases().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonDatabaseName, this.innerModel(), context);
        return this;
    }

    NeonDatabaseImpl(String name, NeonPostgresManager serviceManager) {
        this.innerObject = new NeonDatabaseInner();
        this.serviceManager = serviceManager;
        this.neonDatabaseName = name;
    }

    @Override
    public NeonDatabaseImpl update() {
        return this;
    }

    @Override
    public NeonDatabase apply() {
        this.innerObject = this.serviceManager.serviceClient().getNeonDatabases().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonDatabaseName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public NeonDatabase apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNeonDatabases().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonDatabaseName, this.innerModel(), context);
        return this;
    }

    NeonDatabaseImpl(NeonDatabaseInner innerObject, NeonPostgresManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.branchName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "branches");
        this.neonDatabaseName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "neonDatabases");
    }

    @Override
    public NeonDatabase refresh() {
        this.innerObject = (NeonDatabaseInner)((Object)this.serviceManager.serviceClient().getNeonDatabases().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonDatabaseName, Context.NONE).getValue());
        return this;
    }

    @Override
    public NeonDatabase refresh(Context context) {
        this.innerObject = (NeonDatabaseInner)((Object)this.serviceManager.serviceClient().getNeonDatabases().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.neonDatabaseName, context).getValue());
        return this;
    }

    @Override
    public NeonDatabaseImpl withProperties(NeonDatabaseProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

