/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.EndpointsClient;
import com.azure.resourcemanager.neonpostgres.fluent.models.EndpointInner;
import com.azure.resourcemanager.neonpostgres.implementation.EndpointImpl;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.Endpoint;
import com.azure.resourcemanager.neonpostgres.models.Endpoints;

public final class EndpointsImpl
implements Endpoints {
    private static final ClientLogger LOGGER = new ClientLogger(EndpointsImpl.class);
    private final EndpointsClient innerClient;
    private final NeonPostgresManager serviceManager;

    public EndpointsImpl(EndpointsClient innerClient, NeonPostgresManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Endpoint> getWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String endpointName, Context context) {
        Response<EndpointInner> inner = this.serviceClient().getWithResponse(resourceGroupName, organizationName, projectName, branchName, endpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new EndpointImpl((EndpointInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Endpoint get(String resourceGroupName, String organizationName, String projectName, String branchName, String endpointName) {
        EndpointInner inner = this.serviceClient().get(resourceGroupName, organizationName, projectName, branchName, endpointName);
        if (inner != null) {
            return new EndpointImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String organizationName, String projectName, String branchName, String endpointName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, endpointName, context);
    }

    @Override
    public void delete(String resourceGroupName, String organizationName, String projectName, String branchName, String endpointName) {
        this.serviceClient().delete(resourceGroupName, organizationName, projectName, branchName, endpointName);
    }

    @Override
    public PagedIterable<Endpoint> list(String resourceGroupName, String organizationName, String projectName, String branchName) {
        PagedIterable<EndpointInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new EndpointImpl((EndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Endpoint> list(String resourceGroupName, String organizationName, String projectName, String branchName, Context context) {
        PagedIterable<EndpointInner> inner = this.serviceClient().list(resourceGroupName, organizationName, projectName, branchName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new EndpointImpl((EndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public Endpoint getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String endpointName = ResourceManagerUtils.getValueFromIdByName(id, "endpoints");
        if (endpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'endpoints'.", id)));
        }
        return (Endpoint)this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, endpointName, Context.NONE).getValue();
    }

    @Override
    public Response<Endpoint> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String endpointName = ResourceManagerUtils.getValueFromIdByName(id, "endpoints");
        if (endpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'endpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, organizationName, projectName, branchName, endpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String endpointName = ResourceManagerUtils.getValueFromIdByName(id, "endpoints");
        if (endpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'endpoints'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, endpointName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String organizationName = ResourceManagerUtils.getValueFromIdByName(id, "organizations");
        if (organizationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'organizations'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        String branchName = ResourceManagerUtils.getValueFromIdByName(id, "branches");
        if (branchName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'branches'.", id)));
        }
        String endpointName = ResourceManagerUtils.getValueFromIdByName(id, "endpoints");
        if (endpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'endpoints'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, organizationName, projectName, branchName, endpointName, context);
    }

    private EndpointsClient serviceClient() {
        return this.innerClient;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public EndpointImpl define(String name) {
        return new EndpointImpl(name, this.manager());
    }
}

