/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.neonpostgres.NeonPostgresManager;
import com.azure.resourcemanager.neonpostgres.fluent.models.ComputeInner;
import com.azure.resourcemanager.neonpostgres.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.neonpostgres.models.Compute;
import com.azure.resourcemanager.neonpostgres.models.ComputeProperties;

public final class ComputeImpl
implements Compute,
Compute.Definition,
Compute.Update {
    private ComputeInner innerObject;
    private final NeonPostgresManager serviceManager;
    private String resourceGroupName;
    private String organizationName;
    private String projectName;
    private String branchName;
    private String computeName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ComputeProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ComputeInner innerModel() {
        return this.innerObject;
    }

    private NeonPostgresManager manager() {
        return this.serviceManager;
    }

    @Override
    public ComputeImpl withExistingBranche(String resourceGroupName, String organizationName, String projectName, String branchName) {
        this.resourceGroupName = resourceGroupName;
        this.organizationName = organizationName;
        this.projectName = projectName;
        this.branchName = branchName;
        return this;
    }

    @Override
    public Compute create() {
        this.innerObject = this.serviceManager.serviceClient().getComputes().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.computeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Compute create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getComputes().createOrUpdate(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.computeName, this.innerModel(), context);
        return this;
    }

    ComputeImpl(String name, NeonPostgresManager serviceManager) {
        this.innerObject = new ComputeInner();
        this.serviceManager = serviceManager;
        this.computeName = name;
    }

    @Override
    public ComputeImpl update() {
        return this;
    }

    @Override
    public Compute apply() {
        this.innerObject = this.serviceManager.serviceClient().getComputes().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.computeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Compute apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getComputes().update(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.computeName, this.innerModel(), context);
        return this;
    }

    ComputeImpl(ComputeInner innerObject, NeonPostgresManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.organizationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "organizations");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.branchName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "branches");
        this.computeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "computes");
    }

    @Override
    public Compute refresh() {
        this.innerObject = (ComputeInner)((Object)this.serviceManager.serviceClient().getComputes().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.computeName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Compute refresh(Context context) {
        this.innerObject = (ComputeInner)((Object)this.serviceManager.serviceClient().getComputes().getWithResponse(this.resourceGroupName, this.organizationName, this.projectName, this.branchName, this.computeName, context).getValue());
        return this;
    }

    @Override
    public ComputeImpl withProperties(ComputeProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

