/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.PgVersion;
import java.io.IOException;
import java.util.List;

public final class PgVersionsResultInner
implements JsonSerializable<PgVersionsResultInner> {
    private List<PgVersion> versions;
    private static final ClientLogger LOGGER = new ClientLogger(PgVersionsResultInner.class);

    private PgVersionsResultInner() {
    }

    public List<PgVersion> versions() {
        return this.versions;
    }

    public void validate() {
        if (this.versions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property versions in model PgVersionsResultInner"));
        }
        this.versions().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("versions", this.versions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PgVersionsResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (PgVersionsResultInner)jsonReader.readObject(reader -> {
            PgVersionsResultInner deserializedPgVersionsResultInner = new PgVersionsResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("versions".equals(fieldName)) {
                    List versions;
                    deserializedPgVersionsResultInner.versions = versions = reader.readArray(reader1 -> PgVersion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPgVersionsResultInner;
        });
    }
}

