/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.neonpostgres.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.neonpostgres.models.OrganizationProperties;
import java.io.IOException;
import java.util.Map;

public final class OrganizationResourceInner
extends Resource {
    private OrganizationProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public OrganizationProperties properties() {
        return this.properties;
    }

    public OrganizationResourceInner withProperties(OrganizationProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OrganizationResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public OrganizationResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static OrganizationResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (OrganizationResourceInner)((Object)jsonReader.readObject(reader -> {
            OrganizationResourceInner deserializedOrganizationResourceInner = new OrganizationResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOrganizationResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOrganizationResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOrganizationResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedOrganizationResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedOrganizationResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOrganizationResourceInner.properties = OrganizationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedOrganizationResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOrganizationResourceInner;
        }));
    }
}

