/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class WorkspaceUpdate
implements JsonSerializable<WorkspaceUpdate> {
    private Sku sku;
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public WorkspaceUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public WorkspaceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceUpdate)jsonReader.readObject(reader -> {
            WorkspaceUpdate deserializedWorkspaceUpdate = new WorkspaceUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedWorkspaceUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedWorkspaceUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceUpdate;
        });
    }
}

