/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.iotfirmwaredefense.models.GenerateUploadUrlRequest;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Sku;
import com.azure.resourcemanager.iotfirmwaredefense.models.UrlToken;
import java.util.Map;

public interface Workspace {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public Sku sku();

    public SystemData systemData();

    public ProvisioningState provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public WorkspaceInner innerModel();

    public Update update();

    public Workspace refresh();

    public Workspace refresh(Context var1);

    public Response<UrlToken> generateUploadUrlWithResponse(GenerateUploadUrlRequest var1, Context var2);

    public UrlToken generateUploadUrl(GenerateUploadUrlRequest var1);

    public static interface UpdateStages {

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku {
        public Workspace apply();

        public Workspace apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithSku {
            public Workspace create();

            public Workspace create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

