/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryResourceProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;
import java.io.IOException;

public final class FirmwareSummary
extends SummaryResourceProperties {
    private SummaryType summaryType = SummaryType.FIRMWARE;
    private Long extractedSize;
    private Long fileSize;
    private Long extractedFileCount;
    private Long componentCount;
    private Long binaryCount;
    private Long analysisTimeSeconds;
    private Long rootFileSystems;

    private FirmwareSummary() {
    }

    @Override
    public SummaryType summaryType() {
        return this.summaryType;
    }

    public Long extractedSize() {
        return this.extractedSize;
    }

    public Long fileSize() {
        return this.fileSize;
    }

    public Long extractedFileCount() {
        return this.extractedFileCount;
    }

    public Long componentCount() {
        return this.componentCount;
    }

    public Long binaryCount() {
        return this.binaryCount;
    }

    public Long analysisTimeSeconds() {
        return this.analysisTimeSeconds;
    }

    public Long rootFileSystems() {
        return this.rootFileSystems;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summaryType", this.summaryType == null ? null : this.summaryType.toString());
        jsonWriter.writeNumberField("extractedSize", (Number)this.extractedSize);
        jsonWriter.writeNumberField("fileSize", (Number)this.fileSize);
        jsonWriter.writeNumberField("extractedFileCount", (Number)this.extractedFileCount);
        jsonWriter.writeNumberField("componentCount", (Number)this.componentCount);
        jsonWriter.writeNumberField("binaryCount", (Number)this.binaryCount);
        jsonWriter.writeNumberField("analysisTimeSeconds", (Number)this.analysisTimeSeconds);
        jsonWriter.writeNumberField("rootFileSystems", (Number)this.rootFileSystems);
        return jsonWriter.writeEndObject();
    }

    public static FirmwareSummary fromJson(JsonReader jsonReader) throws IOException {
        return (FirmwareSummary)jsonReader.readObject(reader -> {
            FirmwareSummary deserializedFirmwareSummary = new FirmwareSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedFirmwareSummary.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("summaryType".equals(fieldName)) {
                    deserializedFirmwareSummary.summaryType = SummaryType.fromString(reader.getString());
                    continue;
                }
                if ("extractedSize".equals(fieldName)) {
                    deserializedFirmwareSummary.extractedSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fileSize".equals(fieldName)) {
                    deserializedFirmwareSummary.fileSize = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("extractedFileCount".equals(fieldName)) {
                    deserializedFirmwareSummary.extractedFileCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("componentCount".equals(fieldName)) {
                    deserializedFirmwareSummary.componentCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("binaryCount".equals(fieldName)) {
                    deserializedFirmwareSummary.binaryCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("analysisTimeSeconds".equals(fieldName)) {
                    deserializedFirmwareSummary.analysisTimeSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("rootFileSystems".equals(fieldName)) {
                    deserializedFirmwareSummary.rootFileSystems = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirmwareSummary;
        });
    }
}

