/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.FirmwareInner;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Status;
import com.azure.resourcemanager.iotfirmwaredefense.models.StatusMessage;
import java.util.List;

public interface Firmware {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String fileName();

    public String vendor();

    public String model();

    public String version();

    public String description();

    public Long fileSize();

    public Status status();

    public List<StatusMessage> statusMessages();

    public ProvisioningState provisioningState();

    public String resourceGroupName();

    public FirmwareInner innerModel();

    public Update update();

    public Firmware refresh();

    public Firmware refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithStatusMessages {
            public Update withStatusMessages(List<StatusMessage> var1);
        }

        public static interface WithStatus {
            public Update withStatus(Status var1);
        }

        public static interface WithFileSize {
            public Update withFileSize(Long var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithVersion {
            public Update withVersion(String var1);
        }

        public static interface WithModel {
            public Update withModel(String var1);
        }

        public static interface WithVendor {
            public Update withVendor(String var1);
        }

        public static interface WithFileName {
            public Update withFileName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithFileName,
    UpdateStages.WithVendor,
    UpdateStages.WithModel,
    UpdateStages.WithVersion,
    UpdateStages.WithDescription,
    UpdateStages.WithFileSize,
    UpdateStages.WithStatus,
    UpdateStages.WithStatusMessages {
        public Firmware apply();

        public Firmware apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithStatusMessages {
            public WithCreate withStatusMessages(List<StatusMessage> var1);
        }

        public static interface WithStatus {
            public WithCreate withStatus(Status var1);
        }

        public static interface WithFileSize {
            public WithCreate withFileSize(Long var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithVersion {
            public WithCreate withVersion(String var1);
        }

        public static interface WithModel {
            public WithCreate withModel(String var1);
        }

        public static interface WithVendor {
            public WithCreate withVendor(String var1);
        }

        public static interface WithFileName {
            public WithCreate withFileName(String var1);
        }

        public static interface WithCreate
        extends WithFileName,
        WithVendor,
        WithModel,
        WithVersion,
        WithDescription,
        WithFileSize,
        WithStatus,
        WithStatusMessages {
            public Firmware create();

            public Firmware create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingWorkspace(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

