/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryResourceProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;
import java.io.IOException;

public final class CryptoKeySummaryResource
extends SummaryResourceProperties {
    private SummaryType summaryType = SummaryType.CRYPTO_KEY;
    private Long totalKeyCount;
    private Long publicKeyCount;
    private Long privateKeyCount;
    private Long pairedKeyCount;
    private Long shortKeySizeCount;

    private CryptoKeySummaryResource() {
    }

    @Override
    public SummaryType summaryType() {
        return this.summaryType;
    }

    public Long totalKeyCount() {
        return this.totalKeyCount;
    }

    public Long publicKeyCount() {
        return this.publicKeyCount;
    }

    public Long privateKeyCount() {
        return this.privateKeyCount;
    }

    public Long pairedKeyCount() {
        return this.pairedKeyCount;
    }

    public Long shortKeySizeCount() {
        return this.shortKeySizeCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("summaryType", this.summaryType == null ? null : this.summaryType.toString());
        jsonWriter.writeNumberField("totalKeyCount", (Number)this.totalKeyCount);
        jsonWriter.writeNumberField("publicKeyCount", (Number)this.publicKeyCount);
        jsonWriter.writeNumberField("privateKeyCount", (Number)this.privateKeyCount);
        jsonWriter.writeNumberField("pairedKeyCount", (Number)this.pairedKeyCount);
        jsonWriter.writeNumberField("shortKeySizeCount", (Number)this.shortKeySizeCount);
        return jsonWriter.writeEndObject();
    }

    public static CryptoKeySummaryResource fromJson(JsonReader jsonReader) throws IOException {
        return (CryptoKeySummaryResource)jsonReader.readObject(reader -> {
            CryptoKeySummaryResource deserializedCryptoKeySummaryResource = new CryptoKeySummaryResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("summaryType".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.summaryType = SummaryType.fromString(reader.getString());
                    continue;
                }
                if ("totalKeyCount".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.totalKeyCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("publicKeyCount".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.publicKeyCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("privateKeyCount".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.privateKeyCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("pairedKeyCount".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.pairedKeyCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("shortKeySizeCount".equals(fieldName)) {
                    deserializedCryptoKeySummaryResource.shortKeySizeCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCryptoKeySummaryResource;
        });
    }
}

