/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.WorkspaceInner;
import java.io.IOException;
import java.util.List;

public final class WorkspaceListResult
implements JsonSerializable<WorkspaceListResult> {
    private List<WorkspaceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceListResult.class);

    private WorkspaceListResult() {
    }

    public List<WorkspaceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WorkspaceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceListResult)jsonReader.readObject(reader -> {
            WorkspaceListResult deserializedWorkspaceListResult = new WorkspaceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWorkspaceListResult.value = value = reader.readArray(reader1 -> WorkspaceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWorkspaceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceListResult;
        });
    }
}

