/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.UsageMetricInner;
import java.io.IOException;
import java.util.List;

public final class UsageMetricListResult
implements JsonSerializable<UsageMetricListResult> {
    private List<UsageMetricInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(UsageMetricListResult.class);

    private UsageMetricListResult() {
    }

    public List<UsageMetricInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model UsageMetricListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static UsageMetricListResult fromJson(JsonReader jsonReader) throws IOException {
        return (UsageMetricListResult)jsonReader.readObject(reader -> {
            UsageMetricListResult deserializedUsageMetricListResult = new UsageMetricListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedUsageMetricListResult.value = value = reader.readArray(reader1 -> UsageMetricInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedUsageMetricListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageMetricListResult;
        });
    }
}

