/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.SummaryResourceInner;
import java.io.IOException;
import java.util.List;

public final class SummaryResourceListResult
implements JsonSerializable<SummaryResourceListResult> {
    private List<SummaryResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SummaryResourceListResult.class);

    private SummaryResourceListResult() {
    }

    public List<SummaryResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SummaryResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SummaryResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SummaryResourceListResult)jsonReader.readObject(reader -> {
            SummaryResourceListResult deserializedSummaryResourceListResult = new SummaryResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSummaryResourceListResult.value = value = reader.readArray(reader1 -> SummaryResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSummaryResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSummaryResourceListResult;
        });
    }
}

