/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.WorkspacesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.UrlTokenInner;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.WorkspaceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.UrlTokenImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.WorkspaceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.models.GenerateUploadUrlRequest;
import com.azure.resourcemanager.iotfirmwaredefense.models.UrlToken;
import com.azure.resourcemanager.iotfirmwaredefense.models.Workspace;
import com.azure.resourcemanager.iotfirmwaredefense.models.Workspaces;

public final class WorkspacesImpl
implements Workspaces {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacesImpl.class);
    private final WorkspacesClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public WorkspacesImpl(WorkspacesClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Workspace> getByResourceGroupWithResponse(String resourceGroupName, String workspaceName, Context context) {
        Response<WorkspaceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, workspaceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WorkspaceImpl((WorkspaceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Workspace getByResourceGroup(String resourceGroupName, String workspaceName) {
        WorkspaceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, workspaceName);
        if (inner != null) {
            return new WorkspaceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String workspaceName) {
        this.serviceClient().delete(resourceGroupName, workspaceName);
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, Context context) {
        this.serviceClient().delete(resourceGroupName, workspaceName, context);
    }

    @Override
    public PagedIterable<Workspace> listByResourceGroup(String resourceGroupName) {
        PagedIterable<WorkspaceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceImpl((WorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workspace> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<WorkspaceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceImpl((WorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workspace> list() {
        PagedIterable<WorkspaceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceImpl((WorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Workspace> list(Context context) {
        PagedIterable<WorkspaceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceImpl((WorkspaceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<UrlToken> generateUploadUrlWithResponse(String resourceGroupName, String workspaceName, GenerateUploadUrlRequest body, Context context) {
        Response<UrlTokenInner> inner = this.serviceClient().generateUploadUrlWithResponse(resourceGroupName, workspaceName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UrlTokenImpl((UrlTokenInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UrlToken generateUploadUrl(String resourceGroupName, String workspaceName, GenerateUploadUrlRequest body) {
        UrlTokenInner inner = this.serviceClient().generateUploadUrl(resourceGroupName, workspaceName, body);
        if (inner != null) {
            return new UrlTokenImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Workspace getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return (Workspace)this.getByResourceGroupWithResponse(resourceGroupName, workspaceName, Context.NONE).getValue();
    }

    @Override
    public Response<Workspace> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, workspaceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        this.delete(resourceGroupName, workspaceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        this.delete(resourceGroupName, workspaceName, context);
    }

    private WorkspacesClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }

    @Override
    public WorkspaceImpl define(String name) {
        return new WorkspaceImpl(name, this.manager());
    }
}

