/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.SummariesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.SummaryResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.SummaryResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.models.Summaries;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.SummaryType;

public final class SummariesImpl
implements Summaries {
    private static final ClientLogger LOGGER = new ClientLogger(SummariesImpl.class);
    private final SummariesClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public SummariesImpl(SummariesClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SummaryResource> getWithResponse(String resourceGroupName, String workspaceName, String firmwareId, SummaryType summaryType, Context context) {
        Response<SummaryResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, firmwareId, summaryType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SummaryResourceImpl((SummaryResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SummaryResource get(String resourceGroupName, String workspaceName, String firmwareId, SummaryType summaryType) {
        SummaryResourceInner inner = this.serviceClient().get(resourceGroupName, workspaceName, firmwareId, summaryType);
        if (inner != null) {
            return new SummaryResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SummaryResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<SummaryResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SummaryResourceImpl((SummaryResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SummaryResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<SummaryResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SummaryResourceImpl((SummaryResourceInner)((Object)inner1), this.manager()));
    }

    private SummariesClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

