/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.SbomComponentsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.SbomComponentResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.SbomComponentResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.models.SbomComponentResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.SbomComponents;

public final class SbomComponentsImpl
implements SbomComponents {
    private static final ClientLogger LOGGER = new ClientLogger(SbomComponentsImpl.class);
    private final SbomComponentsClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public SbomComponentsImpl(SbomComponentsClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SbomComponentResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<SbomComponentResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SbomComponentResourceImpl((SbomComponentResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SbomComponentResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<SbomComponentResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SbomComponentResourceImpl((SbomComponentResourceInner)((Object)inner1), this.manager()));
    }

    private SbomComponentsClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

