/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.PasswordHashesClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.PasswordHashResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.PasswordHashResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.PasswordHashResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.PasswordHashes;

public final class PasswordHashesImpl
implements PasswordHashes {
    private static final ClientLogger LOGGER = new ClientLogger(PasswordHashesImpl.class);
    private final PasswordHashesClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public PasswordHashesImpl(PasswordHashesClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PasswordHashResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<PasswordHashResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PasswordHashResourceImpl((PasswordHashResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PasswordHashResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<PasswordHashResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PasswordHashResourceImpl((PasswordHashResourceInner)((Object)inner1), this.manager()));
    }

    private PasswordHashesClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

