/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.FirmwaresClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.FirmwareInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.FirmwareImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.Firmware;
import com.azure.resourcemanager.iotfirmwaredefense.models.Firmwares;

public final class FirmwaresImpl
implements Firmwares {
    private static final ClientLogger LOGGER = new ClientLogger(FirmwaresImpl.class);
    private final FirmwaresClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public FirmwaresImpl(FirmwaresClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Firmware> getWithResponse(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        Response<FirmwareInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, firmwareId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FirmwareImpl((FirmwareInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Firmware get(String resourceGroupName, String workspaceName, String firmwareId) {
        FirmwareInner inner = this.serviceClient().get(resourceGroupName, workspaceName, firmwareId);
        if (inner != null) {
            return new FirmwareImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, workspaceName, firmwareId, context);
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String firmwareId) {
        this.serviceClient().delete(resourceGroupName, workspaceName, firmwareId);
    }

    @Override
    public PagedIterable<Firmware> listByWorkspace(String resourceGroupName, String workspaceName) {
        PagedIterable<FirmwareInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FirmwareImpl((FirmwareInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Firmware> listByWorkspace(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<FirmwareInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FirmwareImpl((FirmwareInner)((Object)inner1), this.manager()));
    }

    @Override
    public Firmware getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String firmwareId = ResourceManagerUtils.getValueFromIdByName(id, "firmwares");
        if (firmwareId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firmwares'.", id)));
        }
        return (Firmware)this.getWithResponse(resourceGroupName, workspaceName, firmwareId, Context.NONE).getValue();
    }

    @Override
    public Response<Firmware> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String firmwareId = ResourceManagerUtils.getValueFromIdByName(id, "firmwares");
        if (firmwareId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firmwares'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, firmwareId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String firmwareId = ResourceManagerUtils.getValueFromIdByName(id, "firmwares");
        if (firmwareId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firmwares'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, workspaceName, firmwareId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String firmwareId = ResourceManagerUtils.getValueFromIdByName(id, "firmwares");
        if (firmwareId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'firmwares'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, workspaceName, firmwareId, context);
    }

    private FirmwaresClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }

    @Override
    public FirmwareImpl define(String name) {
        return new FirmwareImpl(name, this.manager());
    }
}

