/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.CryptoKeysClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CryptoKeyResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.CryptoKeyResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoKeyResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.CryptoKeys;

public final class CryptoKeysImpl
implements CryptoKeys {
    private static final ClientLogger LOGGER = new ClientLogger(CryptoKeysImpl.class);
    private final CryptoKeysClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public CryptoKeysImpl(CryptoKeysClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CryptoKeyResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<CryptoKeyResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CryptoKeyResourceImpl((CryptoKeyResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CryptoKeyResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<CryptoKeyResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CryptoKeyResourceImpl((CryptoKeyResourceInner)((Object)inner1), this.manager()));
    }

    private CryptoKeysClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

