/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iotfirmwaredefense.IoTFirmwareDefenseManager;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.BinaryHardeningsClient;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.BinaryHardeningResourceInner;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.BinaryHardeningResourceImpl;
import com.azure.resourcemanager.iotfirmwaredefense.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.iotfirmwaredefense.models.BinaryHardeningResource;
import com.azure.resourcemanager.iotfirmwaredefense.models.BinaryHardenings;

public final class BinaryHardeningsImpl
implements BinaryHardenings {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryHardeningsImpl.class);
    private final BinaryHardeningsClient innerClient;
    private final IoTFirmwareDefenseManager serviceManager;

    public BinaryHardeningsImpl(BinaryHardeningsClient innerClient, IoTFirmwareDefenseManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BinaryHardeningResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId) {
        PagedIterable<BinaryHardeningResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BinaryHardeningResourceImpl((BinaryHardeningResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BinaryHardeningResource> listByFirmware(String resourceGroupName, String workspaceName, String firmwareId, Context context) {
        PagedIterable<BinaryHardeningResourceInner> inner = this.serviceClient().listByFirmware(resourceGroupName, workspaceName, firmwareId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BinaryHardeningResourceImpl((BinaryHardeningResourceInner)((Object)inner1), this.manager()));
    }

    private BinaryHardeningsClient serviceClient() {
        return this.innerClient;
    }

    private IoTFirmwareDefenseManager manager() {
        return this.serviceManager;
    }
}

