/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.WorkspaceProperties;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import com.azure.resourcemanager.iotfirmwaredefense.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class WorkspaceInner
extends Resource {
    private WorkspaceProperties innerProperties;
    private Sku sku;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private WorkspaceProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public WorkspaceInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public WorkspaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public WorkspaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceInner)((Object)jsonReader.readObject(reader -> {
            WorkspaceInner deserializedWorkspaceInner = new WorkspaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkspaceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkspaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkspaceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWorkspaceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkspaceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkspaceInner.innerProperties = WorkspaceProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedWorkspaceInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedWorkspaceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceInner;
        }));
    }
}

