/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iotfirmwaredefense.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iotfirmwaredefense.fluent.models.CveResult;
import com.azure.resourcemanager.iotfirmwaredefense.models.CveComponent;
import com.azure.resourcemanager.iotfirmwaredefense.models.CveLink;
import com.azure.resourcemanager.iotfirmwaredefense.models.CvssScore;
import com.azure.resourcemanager.iotfirmwaredefense.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class CveResourceInner
extends ProxyResource {
    private CveResult innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private CveResourceInner() {
    }

    private CveResult innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String cveId() {
        return this.innerProperties() == null ? null : this.innerProperties().cveId();
    }

    public String componentId() {
        return this.innerProperties() == null ? null : this.innerProperties().componentId();
    }

    public String componentName() {
        return this.innerProperties() == null ? null : this.innerProperties().componentName();
    }

    public String componentVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().componentVersion();
    }

    public String severity() {
        return this.innerProperties() == null ? null : this.innerProperties().severity();
    }

    public String cveName() {
        return this.innerProperties() == null ? null : this.innerProperties().cveName();
    }

    public CveComponent component() {
        return this.innerProperties() == null ? null : this.innerProperties().component();
    }

    public String cvssScore() {
        return this.innerProperties() == null ? null : this.innerProperties().cvssScore();
    }

    public String cvssV2Score() {
        return this.innerProperties() == null ? null : this.innerProperties().cvssV2Score();
    }

    public String cvssV3Score() {
        return this.innerProperties() == null ? null : this.innerProperties().cvssV3Score();
    }

    public String cvssVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().cvssVersion();
    }

    public Double effectiveCvssScore() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveCvssScore();
    }

    public Integer effectiveCvssVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveCvssVersion();
    }

    public List<CvssScore> cvssScores() {
        return this.innerProperties() == null ? null : this.innerProperties().cvssScores();
    }

    public List<CveLink> links() {
        return this.innerProperties() == null ? null : this.innerProperties().links();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CveResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (CveResourceInner)((Object)jsonReader.readObject(reader -> {
            CveResourceInner deserializedCveResourceInner = new CveResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCveResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCveResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCveResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCveResourceInner.innerProperties = CveResult.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCveResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCveResourceInner;
        }));
    }
}

