/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.DedicatedHsmsClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.DedicatedHsmInner;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.OutboundEnvironmentEndpointInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.DedicatedHsmImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.OutboundEnvironmentEndpointImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.hardwaresecuritymodules.models.DedicatedHsm;
import com.azure.resourcemanager.hardwaresecuritymodules.models.DedicatedHsms;
import com.azure.resourcemanager.hardwaresecuritymodules.models.OutboundEnvironmentEndpoint;

public final class DedicatedHsmsImpl
implements DedicatedHsms {
    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHsmsImpl.class);
    private final DedicatedHsmsClient innerClient;
    private final HardwareSecurityModulesManager serviceManager;

    public DedicatedHsmsImpl(DedicatedHsmsClient innerClient, HardwareSecurityModulesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DedicatedHsm> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context) {
        Response<DedicatedHsmInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DedicatedHsmImpl((DedicatedHsmInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DedicatedHsm getByResourceGroup(String resourceGroupName, String name) {
        DedicatedHsmInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, name);
        if (inner != null) {
            return new DedicatedHsmImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String name) {
        this.serviceClient().delete(resourceGroupName, name);
    }

    @Override
    public void delete(String resourceGroupName, String name, Context context) {
        this.serviceClient().delete(resourceGroupName, name, context);
    }

    @Override
    public PagedIterable<DedicatedHsm> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DedicatedHsmInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DedicatedHsmImpl((DedicatedHsmInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DedicatedHsm> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        PagedIterable<DedicatedHsmInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DedicatedHsmImpl((DedicatedHsmInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DedicatedHsm> list() {
        PagedIterable<DedicatedHsmInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DedicatedHsmImpl((DedicatedHsmInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DedicatedHsm> list(Integer top, Context context) {
        PagedIterable<DedicatedHsmInner> inner = this.serviceClient().list(top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DedicatedHsmImpl((DedicatedHsmInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OutboundEnvironmentEndpoint> listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String name) {
        PagedIterable<OutboundEnvironmentEndpointInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, name);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OutboundEnvironmentEndpointImpl((OutboundEnvironmentEndpointInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OutboundEnvironmentEndpoint> listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String name, Context context) {
        PagedIterable<OutboundEnvironmentEndpointInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, name, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OutboundEnvironmentEndpointImpl((OutboundEnvironmentEndpointInner)inner1, this.manager()));
    }

    @Override
    public DedicatedHsm getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dedicatedHSMs");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dedicatedHSMs'.", id)));
        }
        return (DedicatedHsm)this.getByResourceGroupWithResponse(resourceGroupName, name, Context.NONE).getValue();
    }

    @Override
    public Response<DedicatedHsm> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dedicatedHSMs");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dedicatedHSMs'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, name, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dedicatedHSMs");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dedicatedHSMs'.", id)));
        }
        this.delete(resourceGroupName, name, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "dedicatedHSMs");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dedicatedHSMs'.", id)));
        }
        this.delete(resourceGroupName, name, context);
    }

    private DedicatedHsmsClient serviceClient() {
        return this.innerClient;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }

    @Override
    public DedicatedHsmImpl define(String name) {
        return new DedicatedHsmImpl(name, this.manager());
    }
}

