/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.CloudHsmClusterInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupResult;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmCluster;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterPatchParameters;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterSku;
import com.azure.resourcemanager.hardwaresecuritymodules.models.ManagedServiceIdentity;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreResult;
import java.util.Collections;
import java.util.Map;

public final class CloudHsmClusterImpl
implements CloudHsmCluster,
CloudHsmCluster.Definition,
CloudHsmCluster.Update {
    private CloudHsmClusterInner innerObject;
    private final HardwareSecurityModulesManager serviceManager;
    private String resourceGroupName;
    private String cloudHsmClusterName;
    private CloudHsmClusterPatchParameters updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public CloudHsmClusterProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public CloudHsmClusterSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CloudHsmClusterInner innerModel() {
        return this.innerObject;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }

    @Override
    public CloudHsmClusterImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public CloudHsmCluster create() {
        this.innerObject = this.serviceManager.serviceClient().getCloudHsmClusters().createOrUpdate(this.resourceGroupName, this.cloudHsmClusterName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public CloudHsmCluster create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCloudHsmClusters().createOrUpdate(this.resourceGroupName, this.cloudHsmClusterName, this.innerModel(), context);
        return this;
    }

    CloudHsmClusterImpl(String name, HardwareSecurityModulesManager serviceManager) {
        this.innerObject = new CloudHsmClusterInner();
        this.serviceManager = serviceManager;
        this.cloudHsmClusterName = name;
    }

    @Override
    public CloudHsmClusterImpl update() {
        this.updateBody = new CloudHsmClusterPatchParameters();
        return this;
    }

    @Override
    public CloudHsmCluster apply() {
        this.innerObject = this.serviceManager.serviceClient().getCloudHsmClusters().update(this.resourceGroupName, this.cloudHsmClusterName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public CloudHsmCluster apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCloudHsmClusters().update(this.resourceGroupName, this.cloudHsmClusterName, this.updateBody, context);
        return this;
    }

    CloudHsmClusterImpl(CloudHsmClusterInner innerObject, HardwareSecurityModulesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.cloudHsmClusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "cloudHsmClusters");
    }

    @Override
    public CloudHsmCluster refresh() {
        this.innerObject = (CloudHsmClusterInner)((Object)this.serviceManager.serviceClient().getCloudHsmClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.cloudHsmClusterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CloudHsmCluster refresh(Context context) {
        this.innerObject = (CloudHsmClusterInner)((Object)this.serviceManager.serviceClient().getCloudHsmClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.cloudHsmClusterName, context).getValue());
        return this;
    }

    @Override
    public BackupResult validateBackupProperties() {
        return this.serviceManager.cloudHsmClusters().validateBackupProperties(this.resourceGroupName, this.cloudHsmClusterName);
    }

    @Override
    public BackupResult validateBackupProperties(BackupRequestProperties backupRequestProperties, Context context) {
        return this.serviceManager.cloudHsmClusters().validateBackupProperties(this.resourceGroupName, this.cloudHsmClusterName, backupRequestProperties, context);
    }

    @Override
    public BackupResult backup() {
        return this.serviceManager.cloudHsmClusters().backup(this.resourceGroupName, this.cloudHsmClusterName);
    }

    @Override
    public BackupResult backup(BackupRequestProperties backupRequestProperties, Context context) {
        return this.serviceManager.cloudHsmClusters().backup(this.resourceGroupName, this.cloudHsmClusterName, backupRequestProperties, context);
    }

    @Override
    public RestoreResult validateRestoreProperties() {
        return this.serviceManager.cloudHsmClusters().validateRestoreProperties(this.resourceGroupName, this.cloudHsmClusterName);
    }

    @Override
    public RestoreResult validateRestoreProperties(RestoreRequestProperties restoreRequestProperties, Context context) {
        return this.serviceManager.cloudHsmClusters().validateRestoreProperties(this.resourceGroupName, this.cloudHsmClusterName, restoreRequestProperties, context);
    }

    @Override
    public RestoreResult restore(RestoreRequestProperties restoreRequestProperties) {
        return this.serviceManager.cloudHsmClusters().restore(this.resourceGroupName, this.cloudHsmClusterName, restoreRequestProperties);
    }

    @Override
    public RestoreResult restore(RestoreRequestProperties restoreRequestProperties, Context context) {
        return this.serviceManager.cloudHsmClusters().restore(this.resourceGroupName, this.cloudHsmClusterName, restoreRequestProperties, context);
    }

    @Override
    public CloudHsmClusterImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public CloudHsmClusterImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public CloudHsmClusterImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public CloudHsmClusterImpl withProperties(CloudHsmClusterProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public CloudHsmClusterImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateBody.withIdentity(identity);
        return this;
    }

    @Override
    public CloudHsmClusterImpl withSku(CloudHsmClusterSku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

