/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.EndpointDependency;
import java.io.IOException;
import java.util.List;

public final class OutboundEnvironmentEndpointInner
implements JsonSerializable<OutboundEnvironmentEndpointInner> {
    private String category;
    private List<EndpointDependency> endpoints;

    private OutboundEnvironmentEndpointInner() {
    }

    public String category() {
        return this.category;
    }

    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OutboundEnvironmentEndpointInner fromJson(JsonReader jsonReader) throws IOException {
        return (OutboundEnvironmentEndpointInner)jsonReader.readObject(reader -> {
            OutboundEnvironmentEndpointInner deserializedOutboundEnvironmentEndpointInner = new OutboundEnvironmentEndpointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedOutboundEnvironmentEndpointInner.category = reader.getString();
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedOutboundEnvironmentEndpointInner.endpoints = endpoints = reader.readArray(reader1 -> EndpointDependency.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundEnvironmentEndpointInner;
        });
    }
}

