/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.durabletask.models.RedundancyState;
import com.azure.resourcemanager.durabletask.models.SchedulerSkuName;
import java.io.IOException;

public final class SchedulerSku
implements JsonSerializable<SchedulerSku> {
    private SchedulerSkuName name;
    private Integer capacity;
    private RedundancyState redundancyState;

    public SchedulerSkuName name() {
        return this.name;
    }

    public SchedulerSku withName(SchedulerSkuName name) {
        this.name = name;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public SchedulerSku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public RedundancyState redundancyState() {
        return this.redundancyState;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static SchedulerSku fromJson(JsonReader jsonReader) throws IOException {
        return (SchedulerSku)jsonReader.readObject(reader -> {
            SchedulerSku deserializedSchedulerSku = new SchedulerSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSchedulerSku.name = SchedulerSkuName.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSchedulerSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("redundancyState".equals(fieldName)) {
                    deserializedSchedulerSku.redundancyState = RedundancyState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchedulerSku;
        });
    }
}

