/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.durabletask.DurableTaskManager;
import com.azure.resourcemanager.durabletask.fluent.SchedulersClient;
import com.azure.resourcemanager.durabletask.fluent.models.SchedulerInner;
import com.azure.resourcemanager.durabletask.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.durabletask.implementation.SchedulerImpl;
import com.azure.resourcemanager.durabletask.models.Scheduler;
import com.azure.resourcemanager.durabletask.models.Schedulers;

public final class SchedulersImpl
implements Schedulers {
    private static final ClientLogger LOGGER = new ClientLogger(SchedulersImpl.class);
    private final SchedulersClient innerClient;
    private final DurableTaskManager serviceManager;

    public SchedulersImpl(SchedulersClient innerClient, DurableTaskManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Scheduler> getByResourceGroupWithResponse(String resourceGroupName, String schedulerName, Context context) {
        Response<SchedulerInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, schedulerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SchedulerImpl((SchedulerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Scheduler getByResourceGroup(String resourceGroupName, String schedulerName) {
        SchedulerInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, schedulerName);
        if (inner != null) {
            return new SchedulerImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String schedulerName) {
        this.serviceClient().delete(resourceGroupName, schedulerName);
    }

    @Override
    public void delete(String resourceGroupName, String schedulerName, Context context) {
        this.serviceClient().delete(resourceGroupName, schedulerName, context);
    }

    @Override
    public PagedIterable<Scheduler> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SchedulerInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchedulerImpl((SchedulerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Scheduler> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SchedulerInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchedulerImpl((SchedulerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Scheduler> list() {
        PagedIterable<SchedulerInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchedulerImpl((SchedulerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Scheduler> list(Context context) {
        PagedIterable<SchedulerInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SchedulerImpl((SchedulerInner)((Object)inner1), this.manager()));
    }

    @Override
    public Scheduler getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        return (Scheduler)this.getByResourceGroupWithResponse(resourceGroupName, schedulerName, Context.NONE).getValue();
    }

    @Override
    public Response<Scheduler> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, schedulerName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        this.delete(resourceGroupName, schedulerName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        this.delete(resourceGroupName, schedulerName, context);
    }

    private SchedulersClient serviceClient() {
        return this.innerClient;
    }

    private DurableTaskManager manager() {
        return this.serviceManager;
    }

    @Override
    public SchedulerImpl define(String name) {
        return new SchedulerImpl(name, this.manager());
    }
}

