/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.fluent.models.InboundEndpointInner;
import com.azure.resourcemanager.dnsresolver.models.IpConfiguration;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.List;
import java.util.Map;

public interface InboundEndpoint {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public List<IpConfiguration> ipConfigurations();

    public ProvisioningState provisioningState();

    public String resourceGuid();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public InboundEndpointInner innerModel();

    public Update update();

    public InboundEndpoint refresh();

    public InboundEndpoint refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIfMatch {
        public InboundEndpoint apply();

        public InboundEndpoint apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIfMatch,
        WithIfNoneMatch {
            public InboundEndpoint create();

            public InboundEndpoint create(Context var1);
        }

        public static interface WithIpConfigurations {
            public WithCreate withIpConfigurations(List<IpConfiguration> var1);
        }

        public static interface WithParentResource {
            public WithIpConfigurations withExistingDnsResolver(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithIpConfigurations,
    DefinitionStages.WithCreate {
    }
}

