/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsSecurityRuleInner;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleAction;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleState;
import com.azure.resourcemanager.dnsresolver.models.ManagedDomainList;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.List;
import java.util.Map;

public interface DnsSecurityRule {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public int priority();

    public DnsSecurityRuleAction action();

    public List<SubResource> dnsResolverDomainLists();

    public List<ManagedDomainList> managedDomainLists();

    public DnsSecurityRuleState dnsSecurityRuleState();

    public ProvisioningState provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public DnsSecurityRuleInner innerModel();

    public Update update();

    public DnsSecurityRule refresh();

    public DnsSecurityRule refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithPriority {
            public Update withPriority(Integer var1);
        }

        public static interface WithDnsSecurityRuleState {
            public Update withDnsSecurityRuleState(DnsSecurityRuleState var1);
        }

        public static interface WithManagedDomainLists {
            public Update withManagedDomainLists(List<ManagedDomainList> var1);
        }

        public static interface WithDnsResolverDomainLists {
            public Update withDnsResolverDomainLists(List<SubResource> var1);
        }

        public static interface WithAction {
            public Update withAction(DnsSecurityRuleAction var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAction,
    UpdateStages.WithDnsResolverDomainLists,
    UpdateStages.WithManagedDomainLists,
    UpdateStages.WithDnsSecurityRuleState,
    UpdateStages.WithPriority,
    UpdateStages.WithIfMatch {
        public DnsSecurityRule apply();

        public DnsSecurityRule apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithDnsSecurityRuleState {
            public WithCreate withDnsSecurityRuleState(DnsSecurityRuleState var1);
        }

        public static interface WithManagedDomainLists {
            public WithCreate withManagedDomainLists(List<ManagedDomainList> var1);
        }

        public static interface WithDnsResolverDomainLists {
            public WithCreate withDnsResolverDomainLists(List<SubResource> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithDnsResolverDomainLists,
        WithManagedDomainLists,
        WithDnsSecurityRuleState,
        WithIfMatch,
        WithIfNoneMatch {
            public DnsSecurityRule create();

            public DnsSecurityRule create(Context var1);
        }

        public static interface WithAction {
            public WithCreate withAction(DnsSecurityRuleAction var1);
        }

        public static interface WithPriority {
            public WithAction withPriority(int var1);
        }

        public static interface WithParentResource {
            public WithPriority withExistingDnsResolverPolicy(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithPriority,
    DefinitionStages.WithAction,
    DefinitionStages.WithCreate {
    }
}

