/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverInner;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Map;

public interface DnsResolver {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemData systemData();

    public SubResource virtualNetwork();

    public DnsResolverState dnsResolverState();

    public ProvisioningState provisioningState();

    public String resourceGuid();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public DnsResolverInner innerModel();

    public Update update();

    public DnsResolver refresh();

    public DnsResolver refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIfMatch {
        public DnsResolver apply();

        public DnsResolver apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIfMatch,
        WithIfNoneMatch {
            public DnsResolver create();

            public DnsResolver create(Context var1);
        }

        public static interface WithVirtualNetwork {
            public WithCreate withVirtualNetwork(SubResource var1);
        }

        public static interface WithResourceGroup {
            public WithVirtualNetwork withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithVirtualNetwork,
    DefinitionStages.WithCreate {
    }
}

