/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.VirtualNetworkLinkInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import com.azure.resourcemanager.dnsresolver.models.VirtualNetworkLink;
import com.azure.resourcemanager.dnsresolver.models.VirtualNetworkLinkPatch;
import java.util.Collections;
import java.util.Map;

public final class VirtualNetworkLinkImpl
implements VirtualNetworkLink,
VirtualNetworkLink.Definition,
VirtualNetworkLink.Update {
    private VirtualNetworkLinkInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsForwardingRulesetName;
    private String virtualNetworkLinkName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private VirtualNetworkLinkPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SubResource virtualNetwork() {
        return this.innerModel().virtualNetwork();
    }

    @Override
    public Map<String, String> metadata() {
        Map<String, String> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VirtualNetworkLinkInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualNetworkLinkImpl withExistingDnsForwardingRuleset(String resourceGroupName, String dnsForwardingRulesetName) {
        this.resourceGroupName = resourceGroupName;
        this.dnsForwardingRulesetName = dnsForwardingRulesetName;
        return this;
    }

    @Override
    public VirtualNetworkLink create() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkLinks().createOrUpdate(this.resourceGroupName, this.dnsForwardingRulesetName, this.virtualNetworkLinkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public VirtualNetworkLink create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkLinks().createOrUpdate(this.resourceGroupName, this.dnsForwardingRulesetName, this.virtualNetworkLinkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    VirtualNetworkLinkImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new VirtualNetworkLinkInner();
        this.serviceManager = serviceManager;
        this.virtualNetworkLinkName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public VirtualNetworkLinkImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new VirtualNetworkLinkPatch();
        return this;
    }

    @Override
    public VirtualNetworkLink apply() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkLinks().update(this.resourceGroupName, this.dnsForwardingRulesetName, this.virtualNetworkLinkName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public VirtualNetworkLink apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkLinks().update(this.resourceGroupName, this.dnsForwardingRulesetName, this.virtualNetworkLinkName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    VirtualNetworkLinkImpl(VirtualNetworkLinkInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsForwardingRulesets");
        this.virtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualNetworkLinks");
    }

    @Override
    public VirtualNetworkLink refresh() {
        this.innerObject = (VirtualNetworkLinkInner)((Object)this.serviceManager.serviceClient().getVirtualNetworkLinks().getWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.virtualNetworkLinkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public VirtualNetworkLink refresh(Context context) {
        this.innerObject = (VirtualNetworkLinkInner)((Object)this.serviceManager.serviceClient().getVirtualNetworkLinks().getWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.virtualNetworkLinkName, context).getValue());
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl withVirtualNetwork(SubResource virtualNetwork) {
        this.innerModel().withVirtualNetwork(virtualNetwork);
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl withMetadata(Map<String, String> metadata) {
        if (this.isInCreateMode()) {
            this.innerModel().withMetadata(metadata);
            return this;
        }
        this.updateParameters.withMetadata(metadata);
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public VirtualNetworkLinkImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

