/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.InboundEndpointInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpoint;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpointPatch;
import com.azure.resourcemanager.dnsresolver.models.IpConfiguration;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class InboundEndpointImpl
implements InboundEndpoint,
InboundEndpoint.Definition,
InboundEndpoint.Update {
    private InboundEndpointInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverName;
    private String inboundEndpointName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private InboundEndpointPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<IpConfiguration> ipConfigurations() {
        List<IpConfiguration> inner = this.innerModel().ipConfigurations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGuid() {
        return this.innerModel().resourceGuid();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public InboundEndpointInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public InboundEndpointImpl withExistingDnsResolver(String resourceGroupName, String dnsResolverName) {
        this.resourceGroupName = resourceGroupName;
        this.dnsResolverName = dnsResolverName;
        return this;
    }

    @Override
    public InboundEndpoint create() {
        this.innerObject = this.serviceManager.serviceClient().getInboundEndpoints().createOrUpdate(this.resourceGroupName, this.dnsResolverName, this.inboundEndpointName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public InboundEndpoint create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getInboundEndpoints().createOrUpdate(this.resourceGroupName, this.dnsResolverName, this.inboundEndpointName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    InboundEndpointImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new InboundEndpointInner();
        this.serviceManager = serviceManager;
        this.inboundEndpointName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public InboundEndpointImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new InboundEndpointPatch();
        return this;
    }

    @Override
    public InboundEndpoint apply() {
        this.innerObject = this.serviceManager.serviceClient().getInboundEndpoints().update(this.resourceGroupName, this.dnsResolverName, this.inboundEndpointName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public InboundEndpoint apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getInboundEndpoints().update(this.resourceGroupName, this.dnsResolverName, this.inboundEndpointName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    InboundEndpointImpl(InboundEndpointInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolvers");
        this.inboundEndpointName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "inboundEndpoints");
    }

    @Override
    public InboundEndpoint refresh() {
        this.innerObject = (InboundEndpointInner)((Object)this.serviceManager.serviceClient().getInboundEndpoints().getWithResponse(this.resourceGroupName, this.dnsResolverName, this.inboundEndpointName, Context.NONE).getValue());
        return this;
    }

    @Override
    public InboundEndpoint refresh(Context context) {
        this.innerObject = (InboundEndpointInner)((Object)this.serviceManager.serviceClient().getInboundEndpoints().getWithResponse(this.resourceGroupName, this.dnsResolverName, this.inboundEndpointName, context).getValue());
        return this;
    }

    @Override
    public InboundEndpointImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public InboundEndpointImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public InboundEndpointImpl withIpConfigurations(List<IpConfiguration> ipConfigurations) {
        this.innerModel().withIpConfigurations(ipConfigurations);
        return this;
    }

    @Override
    public InboundEndpointImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public InboundEndpointImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public InboundEndpointImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

