/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.ForwardingRulesClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.ForwardingRuleInner;
import com.azure.resourcemanager.dnsresolver.implementation.ForwardingRuleImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRule;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRules;

public final class ForwardingRulesImpl
implements ForwardingRules {
    private static final ClientLogger LOGGER = new ClientLogger(ForwardingRulesImpl.class);
    private final ForwardingRulesClient innerClient;
    private final DnsResolverManager serviceManager;

    public ForwardingRulesImpl(ForwardingRulesClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ForwardingRule> getWithResponse(String resourceGroupName, String dnsForwardingRulesetName, String forwardingRuleName, Context context) {
        Response<ForwardingRuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ForwardingRuleImpl((ForwardingRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ForwardingRule get(String resourceGroupName, String dnsForwardingRulesetName, String forwardingRuleName) {
        ForwardingRuleInner inner = this.serviceClient().get(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName);
        if (inner != null) {
            return new ForwardingRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String dnsForwardingRulesetName, String forwardingRuleName, String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, ifMatch, context);
    }

    @Override
    public void delete(String resourceGroupName, String dnsForwardingRulesetName, String forwardingRuleName) {
        this.serviceClient().delete(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName);
    }

    @Override
    public PagedIterable<ForwardingRule> list(String resourceGroupName, String dnsForwardingRulesetName) {
        PagedIterable<ForwardingRuleInner> inner = this.serviceClient().list(resourceGroupName, dnsForwardingRulesetName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ForwardingRuleImpl((ForwardingRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ForwardingRule> list(String resourceGroupName, String dnsForwardingRulesetName, Integer top, Context context) {
        PagedIterable<ForwardingRuleInner> inner = this.serviceClient().list(resourceGroupName, dnsForwardingRulesetName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ForwardingRuleImpl((ForwardingRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public ForwardingRule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String forwardingRuleName = ResourceManagerUtils.getValueFromIdByName(id, "forwardingRules");
        if (forwardingRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'forwardingRules'.", id)));
        }
        return (ForwardingRule)this.getWithResponse(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, Context.NONE).getValue();
    }

    @Override
    public Response<ForwardingRule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String forwardingRuleName = ResourceManagerUtils.getValueFromIdByName(id, "forwardingRules");
        if (forwardingRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'forwardingRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String forwardingRuleName = ResourceManagerUtils.getValueFromIdByName(id, "forwardingRules");
        if (forwardingRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'forwardingRules'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, localIfMatch, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(id, "dnsForwardingRulesets");
        if (dnsForwardingRulesetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsForwardingRulesets'.", id)));
        }
        String forwardingRuleName = ResourceManagerUtils.getValueFromIdByName(id, "forwardingRules");
        if (forwardingRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'forwardingRules'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, dnsForwardingRulesetName, forwardingRuleName, ifMatch, context);
    }

    private ForwardingRulesClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public ForwardingRuleImpl define(String name) {
        return new ForwardingRuleImpl(name, this.manager());
    }
}

