/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.SubResource;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolversClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolver;
import com.azure.resourcemanager.dnsresolver.models.DnsResolvers;

public final class DnsResolversImpl
implements DnsResolvers {
    private static final ClientLogger LOGGER = new ClientLogger(DnsResolversImpl.class);
    private final DnsResolversClient innerClient;
    private final DnsResolverManager serviceManager;

    public DnsResolversImpl(DnsResolversClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DnsResolver> getByResourceGroupWithResponse(String resourceGroupName, String dnsResolverName, Context context) {
        Response<DnsResolverInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, dnsResolverName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DnsResolverImpl((DnsResolverInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DnsResolver getByResourceGroup(String resourceGroupName, String dnsResolverName) {
        DnsResolverInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, dnsResolverName);
        if (inner != null) {
            return new DnsResolverImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String dnsResolverName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverName, ifMatch, context);
    }

    @Override
    public PagedIterable<DnsResolver> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DnsResolverInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverImpl((DnsResolverInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolver> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        PagedIterable<DnsResolverInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverImpl((DnsResolverInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolver> list() {
        PagedIterable<DnsResolverInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverImpl((DnsResolverInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolver> list(Integer top, Context context) {
        PagedIterable<DnsResolverInner> inner = this.serviceClient().list(top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverImpl((DnsResolverInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SubResource> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        return this.serviceClient().listByVirtualNetwork(resourceGroupName, virtualNetworkName);
    }

    @Override
    public PagedIterable<SubResource> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName, Integer top, Context context) {
        return this.serviceClient().listByVirtualNetwork(resourceGroupName, virtualNetworkName, top, context);
    }

    @Override
    public DnsResolver getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        return (DnsResolver)this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverName, Context.NONE).getValue();
    }

    @Override
    public Response<DnsResolver> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolvers");
        if (dnsResolverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolvers'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverName, ifMatch, context);
    }

    private DnsResolversClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverImpl define(String name) {
        return new DnsResolverImpl(name, this.manager());
    }
}

