/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.SubResource;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolversClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverManagementClientImpl;
import com.azure.resourcemanager.dnsresolver.implementation.models.DnsResolverListResult;
import com.azure.resourcemanager.dnsresolver.implementation.models.SubResourceListResult;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPatch;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DnsResolversClientImpl
implements DnsResolversClient {
    private final DnsResolversService service;
    private final DnsResolverManagementClientImpl client;

    DnsResolversClientImpl(DnsResolverManagementClientImpl client) {
        this.service = (DnsResolversService)RestProxy.create(DnsResolversService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DnsResolverInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String dnsResolverName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverInner> getByResourceGroupAsync(String resourceGroupName, String dnsResolverName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, dnsResolverName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DnsResolverInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DnsResolverInner> getByResourceGroupWithResponse(String resourceGroupName, String dnsResolverName, Context context) {
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverInner getByResourceGroup(String resourceGroupName, String dnsResolverName) {
        return (DnsResolverInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, ifNoneMatch, "application/json", "application/json", parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverInner>, DnsResolverInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverInner>, DnsResolverInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverInner>, DnsResolverInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverInner>, DnsResolverInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverInner>, DnsResolverInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverInner> createOrUpdateAsync(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverInner> createOrUpdateAsync(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverInner createOrUpdate(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (DnsResolverInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverInner createOrUpdate(String resourceGroupName, String dnsResolverName, DnsResolverInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (DnsResolverInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsResolverName, parameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, "application/json", "application/json", parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, "application/json", "application/json", parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverInner>, DnsResolverInner> beginUpdateAsync(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsResolverName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DnsResolverInner>, DnsResolverInner> beginUpdateAsync(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsResolverName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverInner>, DnsResolverInner> beginUpdate(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverInner>, DnsResolverInner> beginUpdate(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters) {
        String ifMatch = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DnsResolverInner>, DnsResolverInner> beginUpdate(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverName, parameters, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)DnsResolverInner.class), (Type)((Object)DnsResolverInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverInner> updateAsync(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, dnsResolverName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DnsResolverInner> updateAsync(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, dnsResolverName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverInner update(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters) {
        String ifMatch = null;
        return (DnsResolverInner)((Object)this.beginUpdate(resourceGroupName, dnsResolverName, parameters, ifMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResolverInner update(String resourceGroupName, String dnsResolverName, DnsResolverPatch parameters, String ifMatch, Context context) {
        return (DnsResolverInner)((Object)this.beginUpdate(resourceGroupName, dnsResolverName, parameters, ifMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String dnsResolverName, String ifMatch) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsResolverName, String ifMatch) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsResolverName, String ifMatch, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsResolverName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsResolverName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsResolverName) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsResolverName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverName, String ifMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverName) {
        String ifMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverName, String ifMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverName, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsResolverName, String ifMatch) {
        return this.beginDeleteAsync(resourceGroupName, dnsResolverName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsResolverName) {
        String ifMatch = null;
        return this.beginDeleteAsync(resourceGroupName, dnsResolverName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsResolverName) {
        String ifMatch = null;
        this.beginDelete(resourceGroupName, dnsResolverName, ifMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsResolverName, String ifMatch, Context context) {
        this.beginDelete(resourceGroupName, dnsResolverName, ifMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsResolverInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsResolverInner> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsResolverInner> listByResourceGroupAsync(String resourceGroupName) {
        Integer top = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listByResourceGroupSinglePage(String resourceGroupName, Integer top) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listByResourceGroupSinglePage(String resourceGroupName, Integer top, Context context) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsResolverInner> listByResourceGroup(String resourceGroupName) {
        Integer top = null;
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, top), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsResolverInner> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, top, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsResolverInner>> listSinglePageAsync(Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsResolverInner> listAsync(Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DnsResolverInner> listAsync() {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listSinglePage(Integer top) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listSinglePage(Integer top, Context context) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsResolverInner> list() {
        Integer top = null;
        return new PagedIterable(() -> this.listSinglePage(top), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DnsResolverInner> list(Integer top, Context context) {
        return new PagedIterable(() -> this.listSinglePage(top, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubResource>> listByVirtualNetworkSinglePageAsync(String resourceGroupName, String virtualNetworkName, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualNetwork(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkName, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubResourceListResult)res.getValue()).value(), ((SubResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SubResource> listByVirtualNetworkAsync(String resourceGroupName, String virtualNetworkName, Integer top) {
        return new PagedFlux(() -> this.listByVirtualNetworkSinglePageAsync(resourceGroupName, virtualNetworkName, top), nextLink -> this.listByVirtualNetworkNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SubResource> listByVirtualNetworkAsync(String resourceGroupName, String virtualNetworkName) {
        Integer top = null;
        return new PagedFlux(() -> this.listByVirtualNetworkSinglePageAsync(resourceGroupName, virtualNetworkName, top), nextLink -> this.listByVirtualNetworkNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SubResource> listByVirtualNetworkSinglePage(String resourceGroupName, String virtualNetworkName, Integer top) {
        String accept = "application/json";
        Response<SubResourceListResult> res = this.service.listByVirtualNetworkSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkName, top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubResourceListResult)res.getValue()).value(), ((SubResourceListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SubResource> listByVirtualNetworkSinglePage(String resourceGroupName, String virtualNetworkName, Integer top, Context context) {
        String accept = "application/json";
        Response<SubResourceListResult> res = this.service.listByVirtualNetworkSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, virtualNetworkName, top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubResourceListResult)res.getValue()).value(), ((SubResourceListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubResource> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName) {
        Integer top = null;
        return new PagedIterable(() -> this.listByVirtualNetworkSinglePage(resourceGroupName, virtualNetworkName, top), nextLink -> this.listByVirtualNetworkNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubResource> listByVirtualNetwork(String resourceGroupName, String virtualNetworkName, Integer top, Context context) {
        return new PagedIterable(() -> this.listByVirtualNetworkSinglePage(resourceGroupName, virtualNetworkName, top, context), nextLink -> this.listByVirtualNetworkNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsResolverInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listByResourceGroupNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DnsResolverInner>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DnsResolverInner> listNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DnsResolverListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DnsResolverListResult)res.getValue()).value(), ((DnsResolverListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SubResource>> listByVirtualNetworkNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualNetworkNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubResourceListResult)res.getValue()).value(), ((SubResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SubResource> listByVirtualNetworkNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<SubResourceListResult> res = this.service.listByVirtualNetworkNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubResourceListResult)res.getValue()).value(), ((SubResourceListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SubResource> listByVirtualNetworkNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<SubResourceListResult> res = this.service.listByVirtualNetworkNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SubResourceListResult)res.getValue()).value(), ((SubResourceListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DnsResolverManagementClientDnsResolvers")
    public static interface DnsResolversService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverInner> getByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="if-none-match") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DnsResolverInner var10, Context var11);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="if-none-match") String var7, @HeaderParam(value="Content-Type") String var8, @HeaderParam(value="Accept") String var9, @BodyParam(value="application/json") DnsResolverInner var10, Context var11);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") DnsResolverPatch var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="if-match") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") DnsResolverPatch var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="if-match") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="dnsResolverName") String var5, @HeaderParam(value="if-match") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverListResult>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverListResult> listByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/dnsResolvers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$top") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/dnsResolvers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverListResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$top") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/listDnsResolvers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubResourceListResult>> listByVirtualNetwork(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualNetworkName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/listDnsResolvers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SubResourceListResult> listByVirtualNetworkSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="virtualNetworkName") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverListResult> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResolverListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DnsResolverListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SubResourceListResult>> listByVirtualNetworkNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SubResourceListResult> listByVirtualNetworkNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

