/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolverPolicyVirtualNetworkLinksClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverPolicyVirtualNetworkLinkInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverPolicyVirtualNetworkLinkImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyVirtualNetworkLink;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyVirtualNetworkLinks;

public final class DnsResolverPolicyVirtualNetworkLinksImpl
implements DnsResolverPolicyVirtualNetworkLinks {
    private static final ClientLogger LOGGER = new ClientLogger(DnsResolverPolicyVirtualNetworkLinksImpl.class);
    private final DnsResolverPolicyVirtualNetworkLinksClient innerClient;
    private final DnsResolverManager serviceManager;

    public DnsResolverPolicyVirtualNetworkLinksImpl(DnsResolverPolicyVirtualNetworkLinksClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DnsResolverPolicyVirtualNetworkLink> getWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, Context context) {
        Response<DnsResolverPolicyVirtualNetworkLinkInner> inner = this.serviceClient().getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DnsResolverPolicyVirtualNetworkLinkImpl((DnsResolverPolicyVirtualNetworkLinkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink get(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        DnsResolverPolicyVirtualNetworkLinkInner inner = this.serviceClient().get(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName);
        if (inner != null) {
            return new DnsResolverPolicyVirtualNetworkLinkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String dnsResolverPolicyVirtualNetworkLinkName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, context);
    }

    @Override
    public PagedIterable<DnsResolverPolicyVirtualNetworkLink> list(String resourceGroupName, String dnsResolverPolicyName) {
        PagedIterable<DnsResolverPolicyVirtualNetworkLinkInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverPolicyName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverPolicyVirtualNetworkLinkImpl((DnsResolverPolicyVirtualNetworkLinkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverPolicyVirtualNetworkLink> list(String resourceGroupName, String dnsResolverPolicyName, Integer top, Context context) {
        PagedIterable<DnsResolverPolicyVirtualNetworkLinkInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverPolicyName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverPolicyVirtualNetworkLinkImpl((DnsResolverPolicyVirtualNetworkLinkInner)((Object)inner1), this.manager()));
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLink getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsResolverPolicyVirtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (dnsResolverPolicyVirtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        return (DnsResolverPolicyVirtualNetworkLink)this.getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, Context.NONE).getValue();
    }

    @Override
    public Response<DnsResolverPolicyVirtualNetworkLink> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsResolverPolicyVirtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (dnsResolverPolicyVirtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsResolverPolicyVirtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (dnsResolverPolicyVirtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsResolverPolicyVirtualNetworkLinkName = ResourceManagerUtils.getValueFromIdByName(id, "virtualNetworkLinks");
        if (dnsResolverPolicyVirtualNetworkLinkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualNetworkLinks'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverPolicyName, dnsResolverPolicyVirtualNetworkLinkName, ifMatch, context);
    }

    private DnsResolverPolicyVirtualNetworkLinksClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverPolicyVirtualNetworkLinkImpl define(String name) {
        return new DnsResolverPolicyVirtualNetworkLinkImpl(name, this.manager());
    }
}

