/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolver;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPatch;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class DnsResolverImpl
implements DnsResolver,
DnsResolver.Definition,
DnsResolver.Update {
    private DnsResolverInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private DnsResolverPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public SubResource virtualNetwork() {
        return this.innerModel().virtualNetwork();
    }

    @Override
    public DnsResolverState dnsResolverState() {
        return this.innerModel().dnsResolverState();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGuid() {
        return this.innerModel().resourceGuid();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DnsResolverInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DnsResolver create() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolvers().createOrUpdate(this.resourceGroupName, this.dnsResolverName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolver create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolvers().createOrUpdate(this.resourceGroupName, this.dnsResolverName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    DnsResolverImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new DnsResolverInner();
        this.serviceManager = serviceManager;
        this.dnsResolverName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public DnsResolverImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DnsResolverPatch();
        return this;
    }

    @Override
    public DnsResolver apply() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolvers().update(this.resourceGroupName, this.dnsResolverName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolver apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolvers().update(this.resourceGroupName, this.dnsResolverName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    DnsResolverImpl(DnsResolverInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolvers");
    }

    @Override
    public DnsResolver refresh() {
        this.innerObject = (DnsResolverInner)((Object)this.serviceManager.serviceClient().getDnsResolvers().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsResolverName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DnsResolver refresh(Context context) {
        this.innerObject = (DnsResolverInner)((Object)this.serviceManager.serviceClient().getDnsResolvers().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsResolverName, context).getValue());
        return this;
    }

    @Override
    public DnsResolverImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DnsResolverImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DnsResolverImpl withVirtualNetwork(SubResource virtualNetwork) {
        this.innerModel().withVirtualNetwork(virtualNetwork);
        return this;
    }

    @Override
    public DnsResolverImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DnsResolverImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public DnsResolverImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

