/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.DnsResolverDomainListsClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverDomainListInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverDomainListImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainList;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainListBulk;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverDomainLists;

public final class DnsResolverDomainListsImpl
implements DnsResolverDomainLists {
    private static final ClientLogger LOGGER = new ClientLogger(DnsResolverDomainListsImpl.class);
    private final DnsResolverDomainListsClient innerClient;
    private final DnsResolverManager serviceManager;

    public DnsResolverDomainListsImpl(DnsResolverDomainListsClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DnsResolverDomainList> getByResourceGroupWithResponse(String resourceGroupName, String dnsResolverDomainListName, Context context) {
        Response<DnsResolverDomainListInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, dnsResolverDomainListName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DnsResolverDomainListImpl((DnsResolverDomainListInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DnsResolverDomainList getByResourceGroup(String resourceGroupName, String dnsResolverDomainListName) {
        DnsResolverDomainListInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, dnsResolverDomainListName);
        if (inner != null) {
            return new DnsResolverDomainListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String dnsResolverDomainListName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverDomainListName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverDomainListName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverDomainListName, ifMatch, context);
    }

    @Override
    public PagedIterable<DnsResolverDomainList> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DnsResolverDomainListInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverDomainListImpl((DnsResolverDomainListInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverDomainList> listByResourceGroup(String resourceGroupName, Integer top, Context context) {
        PagedIterable<DnsResolverDomainListInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverDomainListImpl((DnsResolverDomainListInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverDomainList> list() {
        PagedIterable<DnsResolverDomainListInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverDomainListImpl((DnsResolverDomainListInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsResolverDomainList> list(Integer top, Context context) {
        PagedIterable<DnsResolverDomainListInner> inner = this.serviceClient().list(top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsResolverDomainListImpl((DnsResolverDomainListInner)((Object)inner1), this.manager()));
    }

    @Override
    public DnsResolverDomainList bulk(String resourceGroupName, String dnsResolverDomainListName, DnsResolverDomainListBulk parameters) {
        DnsResolverDomainListInner inner = this.serviceClient().bulk(resourceGroupName, dnsResolverDomainListName, parameters);
        if (inner != null) {
            return new DnsResolverDomainListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DnsResolverDomainList bulk(String resourceGroupName, String dnsResolverDomainListName, DnsResolverDomainListBulk parameters, String ifMatch, String ifNoneMatch, Context context) {
        DnsResolverDomainListInner inner = this.serviceClient().bulk(resourceGroupName, dnsResolverDomainListName, parameters, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new DnsResolverDomainListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DnsResolverDomainList getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverDomainListName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverDomainLists");
        if (dnsResolverDomainListName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverDomainLists'.", id)));
        }
        return (DnsResolverDomainList)this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverDomainListName, Context.NONE).getValue();
    }

    @Override
    public Response<DnsResolverDomainList> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverDomainListName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverDomainLists");
        if (dnsResolverDomainListName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverDomainLists'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, dnsResolverDomainListName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverDomainListName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverDomainLists");
        if (dnsResolverDomainListName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverDomainLists'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverDomainListName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverDomainListName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverDomainLists");
        if (dnsResolverDomainListName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverDomainLists'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverDomainListName, ifMatch, context);
    }

    private DnsResolverDomainListsClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverDomainListImpl define(String name) {
        return new DnsResolverDomainListImpl(name, this.manager());
    }
}

