/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.ProcessNameFilterOperator;
import java.io.IOException;
import java.util.List;

public final class ProcessNameFilter
implements JsonSerializable<ProcessNameFilter> {
    private ProcessNameFilterOperator operator;
    private List<String> processNames;
    private static final ClientLogger LOGGER = new ClientLogger(ProcessNameFilter.class);

    public ProcessNameFilterOperator operator() {
        return this.operator;
    }

    public ProcessNameFilter withOperator(ProcessNameFilterOperator operator) {
        this.operator = operator;
        return this;
    }

    public List<String> processNames() {
        return this.processNames;
    }

    public ProcessNameFilter withProcessNames(List<String> processNames) {
        this.processNames = processNames;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model ProcessNameFilter"));
        }
        if (this.processNames() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property processNames in model ProcessNameFilter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("processNames", this.processNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ProcessNameFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ProcessNameFilter)jsonReader.readObject(reader -> {
            ProcessNameFilter deserializedProcessNameFilter = new ProcessNameFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedProcessNameFilter.operator = ProcessNameFilterOperator.fromString(reader.getString());
                    continue;
                }
                if ("processNames".equals(fieldName)) {
                    List processNames;
                    deserializedProcessNameFilter.processNames = processNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProcessNameFilter;
        });
    }
}

