/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ProvisioningState;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardOperation;
import java.io.IOException;
import java.util.List;

public final class ResourceGuard
implements JsonSerializable<ResourceGuard> {
    private ProvisioningState provisioningState;
    private Boolean allowAutoApprovals;
    private List<ResourceGuardOperation> resourceGuardOperations;
    private List<String> vaultCriticalOperationExclusionList;
    private String description;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean allowAutoApprovals() {
        return this.allowAutoApprovals;
    }

    public List<ResourceGuardOperation> resourceGuardOperations() {
        return this.resourceGuardOperations;
    }

    public List<String> vaultCriticalOperationExclusionList() {
        return this.vaultCriticalOperationExclusionList;
    }

    public ResourceGuard withVaultCriticalOperationExclusionList(List<String> vaultCriticalOperationExclusionList) {
        this.vaultCriticalOperationExclusionList = vaultCriticalOperationExclusionList;
        return this;
    }

    public String description() {
        return this.description;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vaultCriticalOperationExclusionList", this.vaultCriticalOperationExclusionList, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceGuard fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGuard)jsonReader.readObject(reader -> {
            ResourceGuard deserializedResourceGuard = new ResourceGuard();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedResourceGuard.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("allowAutoApprovals".equals(fieldName)) {
                    deserializedResourceGuard.allowAutoApprovals = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("resourceGuardOperations".equals(fieldName)) {
                    List resourceGuardOperations;
                    deserializedResourceGuard.resourceGuardOperations = resourceGuardOperations = reader.readArray(reader1 -> ResourceGuardOperation.fromJson(reader1));
                    continue;
                }
                if ("vaultCriticalOperationExclusionList".equals(fieldName)) {
                    List vaultCriticalOperationExclusionList;
                    deserializedResourceGuard.vaultCriticalOperationExclusionList = vaultCriticalOperationExclusionList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedResourceGuard.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGuard;
        });
    }
}

