/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.JobSubTask;
import com.azure.resourcemanager.dataprotection.models.RestoreJobRecoveryPointDetails;
import com.azure.resourcemanager.dataprotection.models.UserFacingWarningDetail;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class JobExtendedInfo
implements JsonSerializable<JobExtendedInfo> {
    private Map<String, String> additionalDetails;
    private String backupInstanceState;
    private Double dataTransferredInBytes;
    private String recoveryDestination;
    private RestoreJobRecoveryPointDetails sourceRecoverPoint;
    private List<JobSubTask> subTasks;
    private RestoreJobRecoveryPointDetails targetRecoverPoint;
    private List<UserFacingWarningDetail> warningDetails;

    private JobExtendedInfo() {
    }

    public Map<String, String> additionalDetails() {
        return this.additionalDetails;
    }

    public String backupInstanceState() {
        return this.backupInstanceState;
    }

    public Double dataTransferredInBytes() {
        return this.dataTransferredInBytes;
    }

    public String recoveryDestination() {
        return this.recoveryDestination;
    }

    public RestoreJobRecoveryPointDetails sourceRecoverPoint() {
        return this.sourceRecoverPoint;
    }

    public List<JobSubTask> subTasks() {
        return this.subTasks;
    }

    public RestoreJobRecoveryPointDetails targetRecoverPoint() {
        return this.targetRecoverPoint;
    }

    public List<UserFacingWarningDetail> warningDetails() {
        return this.warningDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("additionalDetails", this.additionalDetails, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static JobExtendedInfo fromJson(JsonReader jsonReader) throws IOException {
        return (JobExtendedInfo)jsonReader.readObject(reader -> {
            JobExtendedInfo deserializedJobExtendedInfo = new JobExtendedInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("additionalDetails".equals(fieldName)) {
                    Map additionalDetails;
                    deserializedJobExtendedInfo.additionalDetails = additionalDetails = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("backupInstanceState".equals(fieldName)) {
                    deserializedJobExtendedInfo.backupInstanceState = reader.getString();
                    continue;
                }
                if ("dataTransferredInBytes".equals(fieldName)) {
                    deserializedJobExtendedInfo.dataTransferredInBytes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("recoveryDestination".equals(fieldName)) {
                    deserializedJobExtendedInfo.recoveryDestination = reader.getString();
                    continue;
                }
                if ("sourceRecoverPoint".equals(fieldName)) {
                    deserializedJobExtendedInfo.sourceRecoverPoint = RestoreJobRecoveryPointDetails.fromJson(reader);
                    continue;
                }
                if ("subTasks".equals(fieldName)) {
                    List subTasks;
                    deserializedJobExtendedInfo.subTasks = subTasks = reader.readArray(reader1 -> JobSubTask.fromJson(reader1));
                    continue;
                }
                if ("targetRecoverPoint".equals(fieldName)) {
                    deserializedJobExtendedInfo.targetRecoverPoint = RestoreJobRecoveryPointDetails.fromJson(reader);
                    continue;
                }
                if ("warningDetails".equals(fieldName)) {
                    List warningDetails;
                    deserializedJobExtendedInfo.warningDetails = warningDetails = reader.readArray(reader1 -> UserFacingWarningDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobExtendedInfo;
        });
    }
}

