/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AuthCredentials;
import com.azure.resourcemanager.dataprotection.models.Datasource;
import com.azure.resourcemanager.dataprotection.models.DatasourceSet;
import com.azure.resourcemanager.dataprotection.models.ItemLevelRestoreCriteria;
import com.azure.resourcemanager.dataprotection.models.RecoveryOption;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import java.io.IOException;
import java.util.List;

public final class ItemLevelRestoreTargetInfo
extends RestoreTargetInfoBase {
    private String objectType = "ItemLevelRestoreTargetInfo";
    private List<ItemLevelRestoreCriteria> restoreCriteria;
    private Datasource datasourceInfo;
    private DatasourceSet datasourceSetInfo;
    private AuthCredentials datasourceAuthCredentials;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public List<ItemLevelRestoreCriteria> restoreCriteria() {
        return this.restoreCriteria;
    }

    public ItemLevelRestoreTargetInfo withRestoreCriteria(List<ItemLevelRestoreCriteria> restoreCriteria) {
        this.restoreCriteria = restoreCriteria;
        return this;
    }

    public Datasource datasourceInfo() {
        return this.datasourceInfo;
    }

    public ItemLevelRestoreTargetInfo withDatasourceInfo(Datasource datasourceInfo) {
        this.datasourceInfo = datasourceInfo;
        return this;
    }

    public DatasourceSet datasourceSetInfo() {
        return this.datasourceSetInfo;
    }

    public ItemLevelRestoreTargetInfo withDatasourceSetInfo(DatasourceSet datasourceSetInfo) {
        this.datasourceSetInfo = datasourceSetInfo;
        return this;
    }

    public AuthCredentials datasourceAuthCredentials() {
        return this.datasourceAuthCredentials;
    }

    public ItemLevelRestoreTargetInfo withDatasourceAuthCredentials(AuthCredentials datasourceAuthCredentials) {
        this.datasourceAuthCredentials = datasourceAuthCredentials;
        return this;
    }

    @Override
    public ItemLevelRestoreTargetInfo withRecoveryOption(RecoveryOption recoveryOption) {
        super.withRecoveryOption(recoveryOption);
        return this;
    }

    @Override
    public ItemLevelRestoreTargetInfo withRestoreLocation(String restoreLocation) {
        super.withRestoreLocation(restoreLocation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryOption", this.recoveryOption() == null ? null : this.recoveryOption().toString());
        jsonWriter.writeStringField("restoreLocation", this.restoreLocation());
        jsonWriter.writeArrayField("restoreCriteria", this.restoreCriteria, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("datasourceInfo", (JsonSerializable)this.datasourceInfo);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeJsonField("datasourceSetInfo", (JsonSerializable)this.datasourceSetInfo);
        jsonWriter.writeJsonField("datasourceAuthCredentials", (JsonSerializable)this.datasourceAuthCredentials);
        return jsonWriter.writeEndObject();
    }

    public static ItemLevelRestoreTargetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ItemLevelRestoreTargetInfo)jsonReader.readObject(reader -> {
            ItemLevelRestoreTargetInfo deserializedItemLevelRestoreTargetInfo = new ItemLevelRestoreTargetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryOption".equals(fieldName)) {
                    deserializedItemLevelRestoreTargetInfo.withRecoveryOption(RecoveryOption.fromString(reader.getString()));
                    continue;
                }
                if ("restoreLocation".equals(fieldName)) {
                    deserializedItemLevelRestoreTargetInfo.withRestoreLocation(reader.getString());
                    continue;
                }
                if ("restoreCriteria".equals(fieldName)) {
                    List restoreCriteria;
                    deserializedItemLevelRestoreTargetInfo.restoreCriteria = restoreCriteria = reader.readArray(reader1 -> ItemLevelRestoreCriteria.fromJson(reader1));
                    continue;
                }
                if ("datasourceInfo".equals(fieldName)) {
                    deserializedItemLevelRestoreTargetInfo.datasourceInfo = Datasource.fromJson(reader);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedItemLevelRestoreTargetInfo.objectType = reader.getString();
                    continue;
                }
                if ("datasourceSetInfo".equals(fieldName)) {
                    deserializedItemLevelRestoreTargetInfo.datasourceSetInfo = DatasourceSet.fromJson(reader);
                    continue;
                }
                if ("datasourceAuthCredentials".equals(fieldName)) {
                    deserializedItemLevelRestoreTargetInfo.datasourceAuthCredentials = AuthCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedItemLevelRestoreTargetInfo;
        });
    }
}

