/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BaseResourceProperties;
import java.io.IOException;

public final class DatasourceSet
implements JsonSerializable<DatasourceSet> {
    private String datasourceType;
    private String objectType;
    private String resourceId;
    private String resourceLocation;
    private String resourceName;
    private String resourceType;
    private String resourceUri;
    private BaseResourceProperties resourceProperties;

    public String datasourceType() {
        return this.datasourceType;
    }

    public DatasourceSet withDatasourceType(String datasourceType) {
        this.datasourceType = datasourceType;
        return this;
    }

    public String objectType() {
        return this.objectType;
    }

    public DatasourceSet withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public DatasourceSet withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String resourceLocation() {
        return this.resourceLocation;
    }

    public DatasourceSet withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public DatasourceSet withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public DatasourceSet withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String resourceUri() {
        return this.resourceUri;
    }

    public DatasourceSet withResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    public BaseResourceProperties resourceProperties() {
        return this.resourceProperties;
    }

    public DatasourceSet withResourceProperties(BaseResourceProperties resourceProperties) {
        this.resourceProperties = resourceProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceID", this.resourceId);
        jsonWriter.writeStringField("datasourceType", this.datasourceType);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("resourceUri", this.resourceUri);
        jsonWriter.writeJsonField("resourceProperties", (JsonSerializable)this.resourceProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatasourceSet fromJson(JsonReader jsonReader) throws IOException {
        return (DatasourceSet)jsonReader.readObject(reader -> {
            DatasourceSet deserializedDatasourceSet = new DatasourceSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceID".equals(fieldName)) {
                    deserializedDatasourceSet.resourceId = reader.getString();
                    continue;
                }
                if ("datasourceType".equals(fieldName)) {
                    deserializedDatasourceSet.datasourceType = reader.getString();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedDatasourceSet.objectType = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedDatasourceSet.resourceLocation = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedDatasourceSet.resourceName = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedDatasourceSet.resourceType = reader.getString();
                    continue;
                }
                if ("resourceUri".equals(fieldName)) {
                    deserializedDatasourceSet.resourceUri = reader.getString();
                    continue;
                }
                if ("resourceProperties".equals(fieldName)) {
                    deserializedDatasourceSet.resourceProperties = BaseResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatasourceSet;
        });
    }
}

