/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AdlsBlobBackupDatasourceParameters;
import com.azure.resourcemanager.dataprotection.models.BackupDatasourceParameters;
import java.io.IOException;
import java.util.List;

public class BlobBackupDatasourceParameters
extends BackupDatasourceParameters {
    private String objectType = "BlobBackupDatasourceParameters";
    private List<String> containersList;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public List<String> containersList() {
        return this.containersList;
    }

    public BlobBackupDatasourceParameters withContainersList(List<String> containersList) {
        this.containersList = containersList;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containersList", this.containersList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static BlobBackupDatasourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BlobBackupDatasourceParameters)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BlobBackupDatasourceParameters blobBackupDatasourceParameters;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AdlsBlobBackupDatasourceParameters".equals(discriminatorValue)) {
                    blobBackupDatasourceParameters = AdlsBlobBackupDatasourceParameters.fromJson(readerToUse.reset());
                    return blobBackupDatasourceParameters;
                }
                blobBackupDatasourceParameters = BlobBackupDatasourceParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                return blobBackupDatasourceParameters;
            }
        });
    }

    static BlobBackupDatasourceParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BlobBackupDatasourceParameters)jsonReader.readObject(reader -> {
            BlobBackupDatasourceParameters deserializedBlobBackupDatasourceParameters = new BlobBackupDatasourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containersList".equals(fieldName)) {
                    List containersList;
                    deserializedBlobBackupDatasourceParameters.containersList = containersList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedBlobBackupDatasourceParameters.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobBackupDatasourceParameters;
        });
    }
}

