/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BcdrSecurityLevel;
import com.azure.resourcemanager.dataprotection.models.FeatureSettings;
import com.azure.resourcemanager.dataprotection.models.MonitoringSettings;
import com.azure.resourcemanager.dataprotection.models.ProvisioningState;
import com.azure.resourcemanager.dataprotection.models.ResourceMoveDetails;
import com.azure.resourcemanager.dataprotection.models.ResourceMoveState;
import com.azure.resourcemanager.dataprotection.models.SecureScoreLevel;
import com.azure.resourcemanager.dataprotection.models.SecuritySettings;
import com.azure.resourcemanager.dataprotection.models.StorageSetting;
import java.io.IOException;
import java.util.List;

public final class BackupVault
implements JsonSerializable<BackupVault> {
    private MonitoringSettings monitoringSettings;
    private ProvisioningState provisioningState;
    private ResourceMoveState resourceMoveState;
    private ResourceMoveDetails resourceMoveDetails;
    private SecuritySettings securitySettings;
    private List<StorageSetting> storageSettings;
    private Boolean isVaultProtectedByResourceGuard;
    private FeatureSettings featureSettings;
    private SecureScoreLevel secureScore;
    private BcdrSecurityLevel bcdrSecurityLevel;
    private List<String> resourceGuardOperationRequests;
    private List<String> replicatedRegions;

    public MonitoringSettings monitoringSettings() {
        return this.monitoringSettings;
    }

    public BackupVault withMonitoringSettings(MonitoringSettings monitoringSettings) {
        this.monitoringSettings = monitoringSettings;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ResourceMoveState resourceMoveState() {
        return this.resourceMoveState;
    }

    public ResourceMoveDetails resourceMoveDetails() {
        return this.resourceMoveDetails;
    }

    public SecuritySettings securitySettings() {
        return this.securitySettings;
    }

    public BackupVault withSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    public List<StorageSetting> storageSettings() {
        return this.storageSettings;
    }

    public BackupVault withStorageSettings(List<StorageSetting> storageSettings) {
        this.storageSettings = storageSettings;
        return this;
    }

    public Boolean isVaultProtectedByResourceGuard() {
        return this.isVaultProtectedByResourceGuard;
    }

    public FeatureSettings featureSettings() {
        return this.featureSettings;
    }

    public BackupVault withFeatureSettings(FeatureSettings featureSettings) {
        this.featureSettings = featureSettings;
        return this;
    }

    public SecureScoreLevel secureScore() {
        return this.secureScore;
    }

    public BcdrSecurityLevel bcdrSecurityLevel() {
        return this.bcdrSecurityLevel;
    }

    public List<String> resourceGuardOperationRequests() {
        return this.resourceGuardOperationRequests;
    }

    public BackupVault withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        this.resourceGuardOperationRequests = resourceGuardOperationRequests;
        return this;
    }

    public List<String> replicatedRegions() {
        return this.replicatedRegions;
    }

    public BackupVault withReplicatedRegions(List<String> replicatedRegions) {
        this.replicatedRegions = replicatedRegions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("storageSettings", this.storageSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("monitoringSettings", (JsonSerializable)this.monitoringSettings);
        jsonWriter.writeJsonField("securitySettings", (JsonSerializable)this.securitySettings);
        jsonWriter.writeJsonField("featureSettings", (JsonSerializable)this.featureSettings);
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("replicatedRegions", this.replicatedRegions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BackupVault fromJson(JsonReader jsonReader) throws IOException {
        return (BackupVault)jsonReader.readObject(reader -> {
            BackupVault deserializedBackupVault = new BackupVault();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageSettings".equals(fieldName)) {
                    List storageSettings;
                    deserializedBackupVault.storageSettings = storageSettings = reader.readArray(reader1 -> StorageSetting.fromJson(reader1));
                    continue;
                }
                if ("monitoringSettings".equals(fieldName)) {
                    deserializedBackupVault.monitoringSettings = MonitoringSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBackupVault.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceMoveState".equals(fieldName)) {
                    deserializedBackupVault.resourceMoveState = ResourceMoveState.fromString(reader.getString());
                    continue;
                }
                if ("resourceMoveDetails".equals(fieldName)) {
                    deserializedBackupVault.resourceMoveDetails = ResourceMoveDetails.fromJson(reader);
                    continue;
                }
                if ("securitySettings".equals(fieldName)) {
                    deserializedBackupVault.securitySettings = SecuritySettings.fromJson(reader);
                    continue;
                }
                if ("isVaultProtectedByResourceGuard".equals(fieldName)) {
                    deserializedBackupVault.isVaultProtectedByResourceGuard = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("featureSettings".equals(fieldName)) {
                    deserializedBackupVault.featureSettings = FeatureSettings.fromJson(reader);
                    continue;
                }
                if ("secureScore".equals(fieldName)) {
                    deserializedBackupVault.secureScore = SecureScoreLevel.fromString(reader.getString());
                    continue;
                }
                if ("bcdrSecurityLevel".equals(fieldName)) {
                    deserializedBackupVault.bcdrSecurityLevel = BcdrSecurityLevel.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests;
                    deserializedBackupVault.resourceGuardOperationRequests = resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("replicatedRegions".equals(fieldName)) {
                    List replicatedRegions;
                    deserializedBackupVault.replicatedRegions = replicatedRegions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupVault;
        });
    }
}

