/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.ResourceGuardsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.DppBaseResourceInner;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.models.DppBaseResourceList;
import com.azure.resourcemanager.dataprotection.implementation.models.ResourceGuardResourceList;
import com.azure.resourcemanager.dataprotection.models.PatchResourceGuardInput;
import reactor.core.publisher.Mono;

public final class ResourceGuardsClientImpl
implements ResourceGuardsClient {
    private final ResourceGuardsService service;
    private final DataProtectionManagementClientImpl client;

    ResourceGuardsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (ResourceGuardsService)RestProxy.create(ResourceGuardsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DppBaseResourceInner>> getDefaultDeleteResourceGuardProxyRequestsObjectWithResponseAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefaultDeleteResourceGuardProxyRequestsObject(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DppBaseResourceInner> getDefaultDeleteResourceGuardProxyRequestsObjectAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        return this.getDefaultDeleteResourceGuardProxyRequestsObjectWithResponseAsync(resourceGroupName, resourceGuardsName, requestName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DppBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DppBaseResourceInner> getDefaultDeleteResourceGuardProxyRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        String accept = "application/json";
        return this.service.getDefaultDeleteResourceGuardProxyRequestsObjectSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DppBaseResourceInner getDefaultDeleteResourceGuardProxyRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        return (DppBaseResourceInner)((Object)this.getDefaultDeleteResourceGuardProxyRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getDeleteResourceGuardProxyRequestsObjectsSinglePageAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeleteResourceGuardProxyRequestsObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjectsAsync(String resourceGroupName, String resourceGuardsName) {
        return new PagedFlux(() -> this.getDeleteResourceGuardProxyRequestsObjectsSinglePageAsync(resourceGroupName, resourceGuardsName), nextLink -> this.getDeleteResourceGuardProxyRequestsObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteResourceGuardProxyRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteResourceGuardProxyRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        return new PagedIterable(() -> this.getDeleteResourceGuardProxyRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName), nextLink -> this.getDeleteResourceGuardProxyRequestsObjectsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        return new PagedIterable(() -> this.getDeleteResourceGuardProxyRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName, context), nextLink -> this.getDeleteResourceGuardProxyRequestsObjectsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceGuardResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResourceGuardResourceInner> getByResourceGroupAsync(String resourceGroupName, String resourceGuardsName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceGuardsName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ResourceGuardResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceGuardResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceGuardResourceInner getByResourceGroup(String resourceGroupName, String resourceGuardsName) {
        return (ResourceGuardResourceInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, resourceGuardsName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceGuardResourceInner>> putWithResponseAsync(String resourceGroupName, String resourceGuardsName, ResourceGuardResourceInner parameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResourceGuardResourceInner> putAsync(String resourceGroupName, String resourceGuardsName, ResourceGuardResourceInner parameters) {
        return this.putWithResponseAsync(resourceGroupName, resourceGuardsName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ResourceGuardResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceGuardResourceInner> putWithResponse(String resourceGroupName, String resourceGuardsName, ResourceGuardResourceInner parameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.putSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", "application/json", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceGuardResourceInner put(String resourceGroupName, String resourceGuardsName, ResourceGuardResourceInner parameters) {
        return (ResourceGuardResourceInner)((Object)this.putWithResponse(resourceGroupName, resourceGuardsName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceGuardResourceInner>> patchWithResponseAsync(String resourceGroupName, String resourceGuardsName, PatchResourceGuardInput parameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.patch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResourceGuardResourceInner> patchAsync(String resourceGroupName, String resourceGuardsName, PatchResourceGuardInput parameters) {
        return this.patchWithResponseAsync(resourceGroupName, resourceGuardsName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ResourceGuardResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceGuardResourceInner> patchWithResponse(String resourceGroupName, String resourceGuardsName, PatchResourceGuardInput parameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.patchSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", "application/json", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceGuardResourceInner patch(String resourceGroupName, String resourceGuardsName, PatchResourceGuardInput parameters) {
        return (ResourceGuardResourceInner)((Object)this.patchWithResponse(resourceGroupName, resourceGuardsName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceGuardsName) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceGuardsName) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceGuardsName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceGuardsName, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceGuardsName) {
        this.deleteWithResponse(resourceGroupName, resourceGuardsName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceGuardResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceGuardResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardResourceInner> listByResourceGroupSinglePage(String resourceGroupName) {
        String accept = "application/json";
        Response<ResourceGuardResourceList> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardResourceInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        String accept = "application/json";
        Response<ResourceGuardResourceList> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceGuardResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceGuardResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceGuardResourceInner>> listSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceGuardResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardResourceInner> listSinglePage() {
        String accept = "application/json";
        Response<ResourceGuardResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardResourceInner> listSinglePage(Context context) {
        String accept = "application/json";
        Response<ResourceGuardResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceGuardResourceInner> list() {
        return new PagedIterable(() -> this.listSinglePage());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceGuardResourceInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DppBaseResourceInner>> getDefaultDisableSoftDeleteRequestsObjectWithResponseAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefaultDisableSoftDeleteRequestsObject(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DppBaseResourceInner> getDefaultDisableSoftDeleteRequestsObjectAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        return this.getDefaultDisableSoftDeleteRequestsObjectWithResponseAsync(resourceGroupName, resourceGuardsName, requestName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DppBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DppBaseResourceInner> getDefaultDisableSoftDeleteRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        String accept = "application/json";
        return this.service.getDefaultDisableSoftDeleteRequestsObjectSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DppBaseResourceInner getDefaultDisableSoftDeleteRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        return (DppBaseResourceInner)((Object)this.getDefaultDisableSoftDeleteRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getDisableSoftDeleteRequestsObjectsSinglePageAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDisableSoftDeleteRequestsObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DppBaseResourceInner> getDisableSoftDeleteRequestsObjectsAsync(String resourceGroupName, String resourceGuardsName) {
        return new PagedFlux(() -> this.getDisableSoftDeleteRequestsObjectsSinglePageAsync(resourceGroupName, resourceGuardsName), nextLink -> this.getDisableSoftDeleteRequestsObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDisableSoftDeleteRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDisableSoftDeleteRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDisableSoftDeleteRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDisableSoftDeleteRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getDisableSoftDeleteRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        return new PagedIterable(() -> this.getDisableSoftDeleteRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName), nextLink -> this.getDisableSoftDeleteRequestsObjectsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getDisableSoftDeleteRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        return new PagedIterable(() -> this.getDisableSoftDeleteRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName, context), nextLink -> this.getDisableSoftDeleteRequestsObjectsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DppBaseResourceInner>> getDefaultUpdateProtectedItemRequestsObjectWithResponseAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefaultUpdateProtectedItemRequestsObject(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DppBaseResourceInner> getDefaultUpdateProtectedItemRequestsObjectAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        return this.getDefaultUpdateProtectedItemRequestsObjectWithResponseAsync(resourceGroupName, resourceGuardsName, requestName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DppBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DppBaseResourceInner> getDefaultUpdateProtectedItemRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        String accept = "application/json";
        return this.service.getDefaultUpdateProtectedItemRequestsObjectSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DppBaseResourceInner getDefaultUpdateProtectedItemRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        return (DppBaseResourceInner)((Object)this.getDefaultUpdateProtectedItemRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getUpdateProtectedItemRequestsObjectsSinglePageAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUpdateProtectedItemRequestsObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DppBaseResourceInner> getUpdateProtectedItemRequestsObjectsAsync(String resourceGroupName, String resourceGuardsName) {
        return new PagedFlux(() -> this.getUpdateProtectedItemRequestsObjectsSinglePageAsync(resourceGroupName, resourceGuardsName), nextLink -> this.getUpdateProtectedItemRequestsObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectedItemRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectedItemRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectedItemRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectedItemRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getUpdateProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        return new PagedIterable(() -> this.getUpdateProtectedItemRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName), nextLink -> this.getUpdateProtectedItemRequestsObjectsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getUpdateProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        return new PagedIterable(() -> this.getUpdateProtectedItemRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName, context), nextLink -> this.getUpdateProtectedItemRequestsObjectsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DppBaseResourceInner>> getDefaultUpdateProtectionPolicyRequestsObjectWithResponseAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefaultUpdateProtectionPolicyRequestsObject(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DppBaseResourceInner> getDefaultUpdateProtectionPolicyRequestsObjectAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        return this.getDefaultUpdateProtectionPolicyRequestsObjectWithResponseAsync(resourceGroupName, resourceGuardsName, requestName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DppBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DppBaseResourceInner> getDefaultUpdateProtectionPolicyRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        String accept = "application/json";
        return this.service.getDefaultUpdateProtectionPolicyRequestsObjectSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DppBaseResourceInner getDefaultUpdateProtectionPolicyRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        return (DppBaseResourceInner)((Object)this.getDefaultUpdateProtectionPolicyRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getUpdateProtectionPolicyRequestsObjectsSinglePageAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUpdateProtectionPolicyRequestsObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjectsAsync(String resourceGroupName, String resourceGuardsName) {
        return new PagedFlux(() -> this.getUpdateProtectionPolicyRequestsObjectsSinglePageAsync(resourceGroupName, resourceGuardsName), nextLink -> this.getUpdateProtectionPolicyRequestsObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectionPolicyRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectionPolicyRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        return new PagedIterable(() -> this.getUpdateProtectionPolicyRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName), nextLink -> this.getUpdateProtectionPolicyRequestsObjectsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        return new PagedIterable(() -> this.getUpdateProtectionPolicyRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName, context), nextLink -> this.getUpdateProtectionPolicyRequestsObjectsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DppBaseResourceInner>> getDefaultDeleteProtectedItemRequestsObjectWithResponseAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefaultDeleteProtectedItemRequestsObject(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DppBaseResourceInner> getDefaultDeleteProtectedItemRequestsObjectAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        return this.getDefaultDeleteProtectedItemRequestsObjectWithResponseAsync(resourceGroupName, resourceGuardsName, requestName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DppBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DppBaseResourceInner> getDefaultDeleteProtectedItemRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        String accept = "application/json";
        return this.service.getDefaultDeleteProtectedItemRequestsObjectSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DppBaseResourceInner getDefaultDeleteProtectedItemRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        return (DppBaseResourceInner)((Object)this.getDefaultDeleteProtectedItemRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getDeleteProtectedItemRequestsObjectsSinglePageAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeleteProtectedItemRequestsObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DppBaseResourceInner> getDeleteProtectedItemRequestsObjectsAsync(String resourceGroupName, String resourceGuardsName) {
        return new PagedFlux(() -> this.getDeleteProtectedItemRequestsObjectsSinglePageAsync(resourceGroupName, resourceGuardsName), nextLink -> this.getDeleteProtectedItemRequestsObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteProtectedItemRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteProtectedItemRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteProtectedItemRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteProtectedItemRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getDeleteProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        return new PagedIterable(() -> this.getDeleteProtectedItemRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName), nextLink -> this.getDeleteProtectedItemRequestsObjectsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getDeleteProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        return new PagedIterable(() -> this.getDeleteProtectedItemRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName, context), nextLink -> this.getDeleteProtectedItemRequestsObjectsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DppBaseResourceInner>> getDefaultBackupSecurityPinRequestsObjectWithResponseAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDefaultBackupSecurityPinRequestsObject(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DppBaseResourceInner> getDefaultBackupSecurityPinRequestsObjectAsync(String resourceGroupName, String resourceGuardsName, String requestName) {
        return this.getDefaultBackupSecurityPinRequestsObjectWithResponseAsync(resourceGroupName, resourceGuardsName, requestName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DppBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DppBaseResourceInner> getDefaultBackupSecurityPinRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        String accept = "application/json";
        return this.service.getDefaultBackupSecurityPinRequestsObjectSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, requestName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DppBaseResourceInner getDefaultBackupSecurityPinRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        return (DppBaseResourceInner)((Object)this.getDefaultBackupSecurityPinRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getBackupSecurityPinRequestsObjectsSinglePageAsync(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBackupSecurityPinRequestsObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DppBaseResourceInner> getBackupSecurityPinRequestsObjectsAsync(String resourceGroupName, String resourceGuardsName) {
        return new PagedFlux(() -> this.getBackupSecurityPinRequestsObjectsSinglePageAsync(resourceGroupName, resourceGuardsName), nextLink -> this.getBackupSecurityPinRequestsObjectsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getBackupSecurityPinRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getBackupSecurityPinRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getBackupSecurityPinRequestsObjectsSinglePage(String resourceGroupName, String resourceGuardsName, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getBackupSecurityPinRequestsObjectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceGuardsName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getBackupSecurityPinRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        return new PagedIterable(() -> this.getBackupSecurityPinRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName), nextLink -> this.getBackupSecurityPinRequestsObjectsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DppBaseResourceInner> getBackupSecurityPinRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        return new PagedIterable(() -> this.getBackupSecurityPinRequestsObjectsSinglePage(resourceGroupName, resourceGuardsName, context), nextLink -> this.getBackupSecurityPinRequestsObjectsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getDeleteResourceGuardProxyRequestsObjectsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeleteResourceGuardProxyRequestsObjectsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjectsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteResourceGuardProxyRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteResourceGuardProxyRequestsObjectsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteResourceGuardProxyRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getDisableSoftDeleteRequestsObjectsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDisableSoftDeleteRequestsObjectsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDisableSoftDeleteRequestsObjectsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDisableSoftDeleteRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDisableSoftDeleteRequestsObjectsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDisableSoftDeleteRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getUpdateProtectedItemRequestsObjectsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUpdateProtectedItemRequestsObjectsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectedItemRequestsObjectsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectedItemRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectedItemRequestsObjectsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectedItemRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getUpdateProtectionPolicyRequestsObjectsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUpdateProtectionPolicyRequestsObjectsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjectsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectionPolicyRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getUpdateProtectionPolicyRequestsObjectsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getUpdateProtectionPolicyRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getDeleteProtectedItemRequestsObjectsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeleteProtectedItemRequestsObjectsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteProtectedItemRequestsObjectsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteProtectedItemRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getDeleteProtectedItemRequestsObjectsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getDeleteProtectedItemRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DppBaseResourceInner>> getBackupSecurityPinRequestsObjectsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBackupSecurityPinRequestsObjectsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getBackupSecurityPinRequestsObjectsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getBackupSecurityPinRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DppBaseResourceInner> getBackupSecurityPinRequestsObjectsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<DppBaseResourceList> res = this.service.getBackupSecurityPinRequestsObjectsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DppBaseResourceList)res.getValue()).value(), ((DppBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientResourceGuards")
    public static interface ResourceGuardsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceInner>> getDefaultDeleteResourceGuardProxyRequestsObject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceInner> getDefaultDeleteResourceGuardProxyRequestsObjectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getDeleteResourceGuardProxyRequestsObjects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getDeleteResourceGuardProxyRequestsObjectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardResourceInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardResourceInner> getByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardResourceInner>> put(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ResourceGuardResourceInner var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardResourceInner> putSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ResourceGuardResourceInner var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardResourceInner>> patch(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") PatchResourceGuardInput var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardResourceInner> patchSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") PatchResourceGuardInput var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardResourceList>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardResourceList> listByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/resourceGuards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardResourceList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/resourceGuards")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardResourceList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceInner>> getDefaultDisableSoftDeleteRequestsObject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceInner> getDefaultDisableSoftDeleteRequestsObjectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getDisableSoftDeleteRequestsObjects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getDisableSoftDeleteRequestsObjectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceInner>> getDefaultUpdateProtectedItemRequestsObject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceInner> getDefaultUpdateProtectedItemRequestsObjectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getUpdateProtectedItemRequestsObjects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getUpdateProtectedItemRequestsObjectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceInner>> getDefaultUpdateProtectionPolicyRequestsObject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceInner> getDefaultUpdateProtectionPolicyRequestsObjectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getUpdateProtectionPolicyRequestsObjects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getUpdateProtectionPolicyRequestsObjectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceInner>> getDefaultDeleteProtectedItemRequestsObject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceInner> getDefaultDeleteProtectedItemRequestsObjectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getDeleteProtectedItemRequestsObjects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getDeleteProtectedItemRequestsObjectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceInner>> getDefaultBackupSecurityPinRequestsObject(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests/{requestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceInner> getDefaultBackupSecurityPinRequestsObjectSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @PathParam(value="requestName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getBackupSecurityPinRequestsObjects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getBackupSecurityPinRequestsObjectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceGuardsName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getDeleteResourceGuardProxyRequestsObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getDeleteResourceGuardProxyRequestsObjectsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getDisableSoftDeleteRequestsObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getDisableSoftDeleteRequestsObjectsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getUpdateProtectedItemRequestsObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getUpdateProtectedItemRequestsObjectsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getUpdateProtectionPolicyRequestsObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getUpdateProtectionPolicyRequestsObjectsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getDeleteProtectedItemRequestsObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getDeleteProtectedItemRequestsObjectsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DppBaseResourceList>> getBackupSecurityPinRequestsObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DppBaseResourceList> getBackupSecurityPinRequestsObjectsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

