/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.RecoveryPointsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupRecoveryPointResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.models.AzureBackupRecoveryPointResourceList;
import reactor.core.publisher.Mono;

public final class RecoveryPointsClientImpl
implements RecoveryPointsClient {
    private final RecoveryPointsService service;
    private final DataProtectionManagementClientImpl client;

    RecoveryPointsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (RecoveryPointsService)RestProxy.create(RecoveryPointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureBackupRecoveryPointResourceInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String backupInstanceName, String recoveryPointId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, backupInstanceName, recoveryPointId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureBackupRecoveryPointResourceInner> getAsync(String resourceGroupName, String vaultName, String backupInstanceName, String recoveryPointId) {
        return this.getWithResponseAsync(resourceGroupName, vaultName, backupInstanceName, recoveryPointId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AzureBackupRecoveryPointResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureBackupRecoveryPointResourceInner> getWithResponse(String resourceGroupName, String vaultName, String backupInstanceName, String recoveryPointId, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, backupInstanceName, recoveryPointId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureBackupRecoveryPointResourceInner get(String resourceGroupName, String vaultName, String backupInstanceName, String recoveryPointId) {
        return (AzureBackupRecoveryPointResourceInner)((Object)this.getWithResponse(resourceGroupName, vaultName, backupInstanceName, recoveryPointId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureBackupRecoveryPointResourceInner>> listSinglePageAsync(String resourceGroupName, String vaultName, String backupInstanceName, String filter, String skipToken) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, backupInstanceName, filter, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupRecoveryPointResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupRecoveryPointResourceInner> listAsync(String resourceGroupName, String vaultName, String backupInstanceName, String filter, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName, backupInstanceName, filter, skipToken));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupRecoveryPointResourceInner> listAsync(String resourceGroupName, String vaultName, String backupInstanceName) {
        String filter = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName, backupInstanceName, filter, skipToken));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupRecoveryPointResourceInner> listSinglePage(String resourceGroupName, String vaultName, String backupInstanceName, String filter, String skipToken) {
        String accept = "application/json";
        Response<AzureBackupRecoveryPointResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, backupInstanceName, filter, skipToken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupRecoveryPointResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupRecoveryPointResourceInner> listSinglePage(String resourceGroupName, String vaultName, String backupInstanceName, String filter, String skipToken, Context context) {
        String accept = "application/json";
        Response<AzureBackupRecoveryPointResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, backupInstanceName, filter, skipToken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupRecoveryPointResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupRecoveryPointResourceInner> list(String resourceGroupName, String vaultName, String backupInstanceName) {
        String filter = null;
        String skipToken = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, vaultName, backupInstanceName, filter, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupRecoveryPointResourceInner> list(String resourceGroupName, String vaultName, String backupInstanceName, String filter, String skipToken, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, vaultName, backupInstanceName, filter, skipToken, context));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientRecoveryPoints")
    public static interface RecoveryPointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}/recoveryPoints/{recoveryPointId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupRecoveryPointResourceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="backupInstanceName") String var6, @PathParam(value="recoveryPointId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}/recoveryPoints/{recoveryPointId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupRecoveryPointResourceInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="backupInstanceName") String var6, @PathParam(value="recoveryPointId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}/recoveryPoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupRecoveryPointResourceList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="backupInstanceName") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$skipToken") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}/recoveryPoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupRecoveryPointResourceList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="backupInstanceName") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$skipToken") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

