/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.JobsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.AzureBackupJobResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.AzureBackupJobResource;
import com.azure.resourcemanager.dataprotection.models.Jobs;

public final class JobsImpl
implements Jobs {
    private static final ClientLogger LOGGER = new ClientLogger(JobsImpl.class);
    private final JobsClient innerClient;
    private final DataProtectionManager serviceManager;

    public JobsImpl(JobsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AzureBackupJobResource> getWithResponse(String resourceGroupName, String vaultName, String jobId, Context context) {
        Response<AzureBackupJobResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, jobId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureBackupJobResourceImpl((AzureBackupJobResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureBackupJobResource get(String resourceGroupName, String vaultName, String jobId) {
        AzureBackupJobResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, jobId);
        if (inner != null) {
            return new AzureBackupJobResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AzureBackupJobResource> list(String resourceGroupName, String vaultName) {
        PagedIterable<AzureBackupJobResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupJobResourceImpl((AzureBackupJobResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureBackupJobResource> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<AzureBackupJobResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupJobResourceImpl((AzureBackupJobResourceInner)((Object)inner1), this.manager()));
    }

    private JobsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

