/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsOperationsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.models.AzureBackupJobResourceList;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreJobsRequest;
import reactor.core.publisher.Mono;

public final class FetchCrossRegionRestoreJobsOperationsClientImpl
implements FetchCrossRegionRestoreJobsOperationsClient {
    private final FetchCrossRegionRestoreJobsOperationsService service;
    private final DataProtectionManagementClientImpl client;

    FetchCrossRegionRestoreJobsOperationsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (FetchCrossRegionRestoreJobsOperationsService)RestProxy.create(FetchCrossRegionRestoreJobsOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureBackupJobResourceInner>> listSinglePageAsync(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters, String filter) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, filter, "application/json", parameters, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupJobResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupJobResourceInner> listAsync(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, location, parameters, filter));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupJobResourceInner> listAsync(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters) {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, location, parameters, filter));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupJobResourceInner> listSinglePage(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters, String filter) {
        String accept = "application/json";
        Response<AzureBackupJobResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, filter, "application/json", parameters, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupJobResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupJobResourceInner> listSinglePage(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters, String filter, Context context) {
        String accept = "application/json";
        Response<AzureBackupJobResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, filter, "application/json", parameters, context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupJobResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupJobResourceInner> list(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters) {
        String filter = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, location, parameters, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupJobResourceInner> list(String resourceGroupName, String location, CrossRegionRestoreJobsRequest parameters, String filter, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, location, parameters, filter, context));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientFetchCrossRegionRestoreJobsOperations")
    public static interface FetchCrossRegionRestoreJobsOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupJobResourceList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="location") String var5, @QueryParam(value="$filter") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CrossRegionRestoreJobsRequest var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupJobResourceList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="location") String var5, @QueryParam(value="$filter") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CrossRegionRestoreJobsRequest var8, Context var9);
    }
}

