/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupInstance;
import java.io.IOException;
import java.util.Map;

public final class BackupInstanceResourceInner
extends ProxyResource {
    private BackupInstance properties;
    private Map<String, String> tags;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public BackupInstance properties() {
        return this.properties;
    }

    public BackupInstanceResourceInner withProperties(BackupInstance properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BackupInstanceResourceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BackupInstanceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupInstanceResourceInner)((Object)jsonReader.readObject(reader -> {
            BackupInstanceResourceInner deserializedBackupInstanceResourceInner = new BackupInstanceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.properties = BackupInstance.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBackupInstanceResourceInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupInstanceResourceInner;
        }));
    }
}

